/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smart.refresh.header;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.scwang.smart.drawable.ProgressDrawable;
import com.scwang.smart.refresh.classics.ArrowDrawable;
import com.scwang.smart.refresh.classics.ClassicsAbstract;
import com.scwang.smart.refresh.header.classics.R;
import com.scwang.smart.refresh.layout.api.RefreshComponent;
import com.scwang.smart.refresh.layout.api.RefreshHeader;
import com.scwang.smart.refresh.layout.api.RefreshLayout;
import com.scwang.smart.refresh.layout.constant.RefreshState;
import com.scwang.smart.refresh.layout.constant.SpinnerStyle;
import com.scwang.smart.refresh.layout.util.SmartUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class ClassicsHeader
extends ClassicsAbstract<ClassicsHeader>
implements RefreshHeader {
    public static final int ID_TEXT_UPDATE = R.id.srl_classics_update;
    public static String REFRESH_HEADER_PULLING = null;
    public static String REFRESH_HEADER_REFRESHING = null;
    public static String REFRESH_HEADER_LOADING = null;
    public static String REFRESH_HEADER_RELEASE = null;
    public static String REFRESH_HEADER_FINISH = null;
    public static String REFRESH_HEADER_FAILED = null;
    public static String REFRESH_HEADER_UPDATE = null;
    public static String REFRESH_HEADER_SECONDARY = null;
    protected String KEY_LAST_UPDATE_TIME = "LAST_UPDATE_TIME";
    protected Date mLastTime;
    protected TextView mLastUpdateText;
    protected SharedPreferences mShared;
    protected DateFormat mLastUpdateFormat;
    protected boolean mEnableLastTime = true;
    protected String mTextPulling;
    protected String mTextRefreshing;
    protected String mTextLoading;
    protected String mTextRelease;
    protected String mTextFinish;
    protected String mTextFailed;
    protected String mTextUpdate;
    protected String mTextSecondary;

    public ClassicsHeader(Context context) {
        this(context, null);
    }

    public ClassicsHeader(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        View.inflate((Context)context, (int)R.layout.srl_classics_header, (ViewGroup)this);
        ClassicsHeader thisView = this;
        ImageView arrowView = this.mArrowView = (ImageView)thisView.findViewById(R.id.srl_classics_arrow);
        TextView updateView = this.mLastUpdateText = (TextView)thisView.findViewById(R.id.srl_classics_update);
        ImageView progressView = this.mProgressView = (ImageView)thisView.findViewById(R.id.srl_classics_progress);
        this.mTitleText = (TextView)thisView.findViewById(R.id.srl_classics_title);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ClassicsHeader);
        RelativeLayout.LayoutParams lpArrow = (RelativeLayout.LayoutParams)arrowView.getLayoutParams();
        RelativeLayout.LayoutParams lpProgress = (RelativeLayout.LayoutParams)progressView.getLayoutParams();
        LinearLayout.LayoutParams lpUpdateText = new LinearLayout.LayoutParams(-2, -2);
        lpUpdateText.topMargin = ta.getDimensionPixelSize(R.styleable.ClassicsHeader_srlTextTimeMarginTop, SmartUtil.dp2px((float)0.0f));
        lpArrow.rightMargin = lpProgress.rightMargin = ta.getDimensionPixelSize(R.styleable.ClassicsHeader_srlDrawableMarginRight, SmartUtil.dp2px((float)20.0f));
        lpArrow.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableArrowSize, lpArrow.width);
        lpArrow.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableArrowSize, lpArrow.height);
        lpProgress.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableProgressSize, lpProgress.width);
        lpProgress.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableProgressSize, lpProgress.height);
        lpArrow.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpArrow.width);
        lpArrow.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpArrow.height);
        lpProgress.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpProgress.width);
        lpProgress.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpProgress.height);
        this.mFinishDuration = ta.getInt(R.styleable.ClassicsHeader_srlFinishDuration, this.mFinishDuration);
        this.mEnableLastTime = ta.getBoolean(R.styleable.ClassicsHeader_srlEnableLastTime, this.mEnableLastTime);
        this.mSpinnerStyle = SpinnerStyle.values[ta.getInt(R.styleable.ClassicsHeader_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal)];
        if (ta.hasValue(R.styleable.ClassicsHeader_srlDrawableArrow)) {
            this.mArrowView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsHeader_srlDrawableArrow));
        } else if (this.mArrowView.getDrawable() == null) {
            this.mArrowDrawable = new ArrowDrawable();
            this.mArrowDrawable.setColor(-10066330);
            this.mArrowView.setImageDrawable((Drawable)this.mArrowDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlDrawableProgress)) {
            this.mProgressView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsHeader_srlDrawableProgress));
        } else if (this.mProgressView.getDrawable() == null) {
            this.mProgressDrawable = new ProgressDrawable();
            this.mProgressDrawable.setColor(-10066330);
            this.mProgressView.setImageDrawable((Drawable)this.mProgressDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlTextSizeTitle)) {
            this.mTitleText.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.ClassicsHeader_srlTextSizeTitle, SmartUtil.dp2px((float)16.0f)));
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlTextSizeTime)) {
            this.mLastUpdateText.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.ClassicsHeader_srlTextSizeTime, SmartUtil.dp2px((float)12.0f)));
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlPrimaryColor)) {
            super.setPrimaryColor(ta.getColor(R.styleable.ClassicsHeader_srlPrimaryColor, 0));
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlAccentColor)) {
            this.setAccentColor(ta.getColor(R.styleable.ClassicsHeader_srlAccentColor, 0));
        }
        this.mTextPulling = ta.hasValue(R.styleable.ClassicsHeader_srlTextPulling) ? ta.getString(R.styleable.ClassicsHeader_srlTextPulling) : (REFRESH_HEADER_PULLING != null ? REFRESH_HEADER_PULLING : context.getString(R.string.srl_header_pulling));
        this.mTextLoading = ta.hasValue(R.styleable.ClassicsHeader_srlTextLoading) ? ta.getString(R.styleable.ClassicsHeader_srlTextLoading) : (REFRESH_HEADER_LOADING != null ? REFRESH_HEADER_LOADING : context.getString(R.string.srl_header_loading));
        this.mTextRelease = ta.hasValue(R.styleable.ClassicsHeader_srlTextRelease) ? ta.getString(R.styleable.ClassicsHeader_srlTextRelease) : (REFRESH_HEADER_RELEASE != null ? REFRESH_HEADER_RELEASE : context.getString(R.string.srl_header_release));
        this.mTextFinish = ta.hasValue(R.styleable.ClassicsHeader_srlTextFinish) ? ta.getString(R.styleable.ClassicsHeader_srlTextFinish) : (REFRESH_HEADER_FINISH != null ? REFRESH_HEADER_FINISH : context.getString(R.string.srl_header_finish));
        this.mTextFailed = ta.hasValue(R.styleable.ClassicsHeader_srlTextFailed) ? ta.getString(R.styleable.ClassicsHeader_srlTextFailed) : (REFRESH_HEADER_FAILED != null ? REFRESH_HEADER_FAILED : context.getString(R.string.srl_header_failed));
        this.mTextSecondary = ta.hasValue(R.styleable.ClassicsHeader_srlTextSecondary) ? ta.getString(R.styleable.ClassicsHeader_srlTextSecondary) : (REFRESH_HEADER_SECONDARY != null ? REFRESH_HEADER_SECONDARY : context.getString(R.string.srl_header_secondary));
        this.mTextRefreshing = ta.hasValue(R.styleable.ClassicsHeader_srlTextRefreshing) ? ta.getString(R.styleable.ClassicsHeader_srlTextRefreshing) : (REFRESH_HEADER_REFRESHING != null ? REFRESH_HEADER_REFRESHING : context.getString(R.string.srl_header_refreshing));
        this.mTextUpdate = ta.hasValue(R.styleable.ClassicsHeader_srlTextUpdate) ? ta.getString(R.styleable.ClassicsHeader_srlTextUpdate) : (REFRESH_HEADER_UPDATE != null ? REFRESH_HEADER_UPDATE : context.getString(R.string.srl_header_update));
        this.mLastUpdateFormat = new SimpleDateFormat(this.mTextUpdate, Locale.getDefault());
        ta.recycle();
        progressView.animate().setInterpolator(null);
        updateView.setVisibility(this.mEnableLastTime ? 0 : 8);
        this.mTitleText.setText((CharSequence)(thisView.isInEditMode() ? this.mTextRefreshing : this.mTextPulling));
        if (thisView.isInEditMode()) {
            arrowView.setVisibility(8);
        } else {
            progressView.setVisibility(8);
        }
        try {
            FragmentManager manager;
            List fragments;
            if (context instanceof FragmentActivity && (fragments = (manager = ((FragmentActivity)context).getSupportFragmentManager()).getFragments()).size() > 0) {
                this.setLastUpdateTime(new Date());
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.KEY_LAST_UPDATE_TIME = this.KEY_LAST_UPDATE_TIME + context.getClass().getName();
        this.mShared = context.getSharedPreferences("ClassicsHeader", 0);
        this.setLastUpdateTime(new Date(this.mShared.getLong(this.KEY_LAST_UPDATE_TIME, System.currentTimeMillis())));
    }

    public int onFinish(@NonNull RefreshLayout layout2, boolean success) {
        if (success) {
            this.mTitleText.setText((CharSequence)this.mTextFinish);
            if (this.mLastTime != null) {
                this.setLastUpdateTime(new Date());
            }
        } else {
            this.mTitleText.setText((CharSequence)this.mTextFailed);
        }
        return super.onFinish(layout2, success);
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        ImageView arrowView = this.mArrowView;
        TextView updateView = this.mLastUpdateText;
        switch (newState) {
            case None: {
                updateView.setVisibility(this.mEnableLastTime ? 0 : 8);
            }
            case PullDownToRefresh: {
                this.mTitleText.setText((CharSequence)this.mTextPulling);
                arrowView.setVisibility(0);
                arrowView.animate().rotation(0.0f);
                break;
            }
            case Refreshing: 
            case RefreshReleased: {
                this.mTitleText.setText((CharSequence)this.mTextRefreshing);
                arrowView.setVisibility(8);
                break;
            }
            case ReleaseToRefresh: {
                this.mTitleText.setText((CharSequence)this.mTextRelease);
                arrowView.animate().rotation(180.0f);
                break;
            }
            case ReleaseToTwoLevel: {
                this.mTitleText.setText((CharSequence)this.mTextSecondary);
                arrowView.animate().rotation(0.0f);
                break;
            }
            case Loading: {
                arrowView.setVisibility(8);
                updateView.setVisibility(this.mEnableLastTime ? 4 : 8);
                this.mTitleText.setText((CharSequence)this.mTextLoading);
            }
        }
    }

    public ClassicsHeader setLastUpdateTime(Date time) {
        ClassicsHeader thisView = this;
        this.mLastTime = time;
        this.mLastUpdateFormat.setCalendar(Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault()));
        this.mLastUpdateText.setText((CharSequence)this.mLastUpdateFormat.format(time));
        if (this.mShared != null && !thisView.isInEditMode()) {
            this.mShared.edit().putLong(this.KEY_LAST_UPDATE_TIME, time.getTime()).apply();
        }
        return this;
    }

    public ClassicsHeader setTimeFormat(DateFormat format) {
        this.mLastUpdateFormat = format;
        if (this.mLastTime != null) {
            this.mLastUpdateText.setText((CharSequence)this.mLastUpdateFormat.format(this.mLastTime));
        }
        return this;
    }

    public ClassicsHeader setLastUpdateText(CharSequence text) {
        this.mLastTime = null;
        this.mLastUpdateText.setText(text);
        return this;
    }

    public ClassicsHeader setAccentColor(@ColorInt int accentColor) {
        this.mLastUpdateText.setTextColor(accentColor & 0xFFFFFF | 0xCC000000);
        return (ClassicsHeader)super.setAccentColor(accentColor);
    }

    public ClassicsHeader setEnableLastTime(boolean enable) {
        TextView updateView = this.mLastUpdateText;
        this.mEnableLastTime = enable;
        updateView.setVisibility(enable ? 0 : 8);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightFor((RefreshComponent)this);
        }
        return this;
    }

    public ClassicsHeader setTextSizeTime(float size) {
        this.mLastUpdateText.setTextSize(size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightFor((RefreshComponent)this);
        }
        return this;
    }

    public ClassicsHeader setTextSizeTime(int unit, float size) {
        this.mLastUpdateText.setTextSize(unit, size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightFor((RefreshComponent)this);
        }
        return this;
    }

    public ClassicsHeader setTextTimeMarginTop(float dp) {
        TextView updateView = this.mLastUpdateText;
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)updateView.getLayoutParams();
        lp.topMargin = SmartUtil.dp2px((float)dp);
        updateView.setLayoutParams((ViewGroup.LayoutParams)lp);
        return this;
    }

    public ClassicsHeader setTextTimeMarginTopPx(int px) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mLastUpdateText.getLayoutParams();
        lp.topMargin = px;
        this.mLastUpdateText.setLayoutParams((ViewGroup.LayoutParams)lp);
        return this;
    }
}

