/*
 * Decompiled with CFR 0.152.
 */
package scalapb_json;

import com.google.protobuf.ByteString;
import com.google.protobuf.ByteString$;
import com.google.protobuf.field_mask.FieldMask;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalapb.descriptors.EnumDescriptor;
import scalapb.descriptors.EnumValueDescriptor;
import scalapb.descriptors.FieldDescriptor;
import scalapb.descriptors.PBoolean;
import scalapb.descriptors.PByteString;
import scalapb.descriptors.PDouble;
import scalapb.descriptors.PEnum;
import scalapb.descriptors.PFloat;
import scalapb.descriptors.PInt;
import scalapb.descriptors.PLong;
import scalapb.descriptors.PString;
import scalapb.descriptors.PValue;
import scalapb.descriptors.ScalaType;
import scalapb_json.JsonFormatException;
import scalapb_json.NameUtils$;

public final class ScalapbJsonCommon$ {
    public static final ScalapbJsonCommon$ MODULE$ = new ScalapbJsonCommon$();
    private static final int PIntDefault = 0;
    private static final long PLongDefault = 0L;
    private static final float PFloatDefault = 0.0f;
    private static final double PDoubleDefault = 0.0;
    private static final boolean PBooleanDefault = false;
    private static final String PStringDefault = "";
    private static final ByteString PByteStringDefault = ByteString$.MODULE$.EMPTY();
    private static final BigInt MAX_UINT64 = package$.MODULE$.BigInt().apply("FFFFFFFFFFFFFFFF", 16);

    public long unsignedInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public PValue defaultValue(FieldDescriptor fd) {
        PInt pInt;
        Predef$.MODULE$.require(fd.isOptional());
        ScalaType scalaType = fd.scalaType();
        if (ScalaType.Int$.MODULE$.equals(scalaType)) {
            pInt = new PInt(PIntDefault);
        } else if (ScalaType.Long$.MODULE$.equals(scalaType)) {
            pInt = new PLong(PLongDefault);
        } else if (ScalaType.Float$.MODULE$.equals(scalaType)) {
            pInt = new PFloat(PFloatDefault);
        } else if (ScalaType.Double$.MODULE$.equals(scalaType)) {
            pInt = new PDouble(PDoubleDefault);
        } else if (ScalaType.Boolean$.MODULE$.equals(scalaType)) {
            pInt = new PBoolean(PBooleanDefault);
        } else if (ScalaType.String$.MODULE$.equals(scalaType)) {
            pInt = new PString(PStringDefault);
        } else if (ScalaType.ByteString$.MODULE$.equals(scalaType)) {
            pInt = new PByteString(PByteStringDefault);
        } else if (scalaType instanceof ScalaType.Enum) {
            ScalaType.Enum enum_ = (ScalaType.Enum)scalaType;
            EnumDescriptor ed = enum_.descriptor();
            pInt = new PEnum((EnumValueDescriptor)ed.values().apply(0));
        } else {
            if (scalaType instanceof ScalaType.Message) {
                throw new RuntimeException("No default value for message");
            }
            throw new MatchError((Object)scalaType);
        }
        return pInt;
    }

    public BigDecimal parseBigDecimal(String value) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = package$.MODULE$.BigDecimal().apply(value);
        }
        catch (Exception e) {
            throw new JsonFormatException(new StringBuilder(21).append("Not a numeric value: ").append(value).toString(), e);
        }
        return bigDecimal;
    }

    public PValue parseInt32(String value) {
        PInt pInt;
        try {
            pInt = new PInt(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value)));
        }
        catch (Exception exception) {
            try {
                pInt = new PInt(this.parseBigDecimal(value).toIntExact());
            }
            catch (Exception e) {
                throw new JsonFormatException(new StringBuilder(20).append("Not an int32 value: ").append(value).toString(), e);
            }
        }
        return pInt;
    }

    public PValue parseInt64(String value) {
        PLong pLong;
        try {
            pLong = new PLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
        }
        catch (Exception exception) {
            BigDecimal bd = this.parseBigDecimal(value);
            try {
                pLong = new PLong(bd.toLongExact());
            }
            catch (Exception e) {
                throw new JsonFormatException(new StringBuilder(20).append("Not an int64 value: ").append(value).toString(), e);
            }
        }
        return pLong;
    }

    public PValue parseUint32(String value) {
        try {
            long result = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value));
            if (result < 0L || result > 0xFFFFFFFFL) {
                throw new JsonFormatException(new StringBuilder(27).append("Out of range uint32 value: ").append(value).toString());
            }
            return new PInt((int)result);
        }
        catch (JsonFormatException e) {
            throw e;
        }
        catch (Exception exception) {
            return (PValue)this.parseBigDecimal(value).toBigIntExact().map((Function1 & Serializable)intVal -> new PLong(ScalapbJsonCommon$.$anonfun$parseUint32$1(value, intVal))).getOrElse((Function0 & Serializable)() -> {
                throw new JsonFormatException(new StringBuilder(21).append("Not an uint32 value: ").append(value).toString());
            });
        }
    }

    public BigInt MAX_UINT64() {
        return MAX_UINT64;
    }

    public PValue parseUint64(String value) {
        return (PValue)this.parseBigDecimal(value).toBigIntExact().map((Function1 & Serializable)intVal -> new PLong(ScalapbJsonCommon$.$anonfun$parseUint64$1(value, intVal))).getOrElse((Function0 & Serializable)() -> {
            throw new JsonFormatException(new StringBuilder(21).append("Not an uint64 value: ").append(value).toString());
        });
    }

    public String jsonName(FieldDescriptor fd) {
        return (String)fd.asProto().jsonName().getOrElse((Function0 & Serializable)() -> NameUtils$.MODULE$.snakeCaseToCamelCase(fd.asProto().getName(), NameUtils$.MODULE$.snakeCaseToCamelCase$default$2()));
    }

    public String fieldMaskToJsonString(FieldMask fieldMask) {
        StringBuilder buf = new StringBuilder();
        BooleanRef first = BooleanRef.create((boolean)true);
        fieldMask.paths().foreach((Function1 & Serializable)path -> {
            ScalapbJsonCommon$.$anonfun$fieldMaskToJsonString$1(first, buf, path);
            return BoxedUnit.UNIT;
        });
        return buf.toString();
    }

    public FieldMask fieldMaskFromJsonString(String value) {
        List result = Predef$.MODULE$.wrapRefArray((Object[])value.split(",")).toIterator().withFilter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1)))).map((Function1 & Serializable)path -> NameUtils$.MODULE$.camelCaseToSnakeCase((String)path)).toList();
        return new FieldMask((Seq)result);
    }

    public static final /* synthetic */ long $anonfun$parseUint32$1(String value$1, BigInt intVal) {
        if (intVal.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || intVal.$greater((Object)BigInt$.MODULE$.long2bigInt(0xFFFFFFFFL))) {
            throw new JsonFormatException(new StringBuilder(27).append("Out of range uint32 value: ").append(value$1).toString());
        }
        return intVal.intValue();
    }

    public static final /* synthetic */ long $anonfun$parseUint64$1(String value$2, BigInt intVal) {
        if (intVal.$less((Object)BigInt$.MODULE$.int2bigInt(0)) || intVal.$greater((Object)MODULE$.MAX_UINT64())) {
            throw new JsonFormatException(new StringBuilder(27).append("Out of range uint64 value: ").append(value$2).toString());
        }
        return intVal.longValue();
    }

    public static final /* synthetic */ void $anonfun$fieldMaskToJsonString$1(BooleanRef first$1, StringBuilder buf$1, String path) {
        block0: {
            if (path.isEmpty()) break block0;
            Object object = !first$1.elem ? buf$1.append(',') : BoxedUnit.UNIT;
            NameUtils$.MODULE$.lowerSnakeCaseToCamelCaseWithBuffer(path, buf$1);
            first$1.elem = false;
        }
    }

    private ScalapbJsonCommon$() {
    }
}

