/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.validators;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.constraints.RequiredIfNull;
import io.github.sashirestela.slimvalidator.util.Reflect;
import java.util.Arrays;
import java.util.Objects;

public class RequiredIfNullValidator
implements ConstraintValidator<RequiredIfNull, Object> {
    private String[] fields;
    private String dependsOn;

    @Override
    public void initialize(RequiredIfNull annotation) {
        this.fields = (String[])annotation.fields().clone();
        this.dependsOn = annotation.dependsOn();
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append(Arrays.toString(this.fields)).append(" must have a value when ").append(this.dependsOn).append(" is null.");
        return message.toString();
    }

    @Override
    public boolean isValid(Object value) {
        Object dependsOnValue = Reflect.getValue(value, this.dependsOn);
        if (Objects.isNull(dependsOnValue)) {
            return Arrays.asList(this.fields).stream().map(field -> Reflect.getValue(value, field)).allMatch(Objects::nonNull);
        }
        return true;
    }
}

