/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.validators;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.exception.ValidationException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public class RangeValidator
implements ConstraintValidator<Range, Object> {
    private double min;
    private double max;
    private boolean isVariableType;

    @Override
    public void initialize(Range annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
        this.isVariableType = annotation.isVariableType();
        if (this.min == -1.7976931348623157E308 && this.max == Double.MAX_VALUE) {
            throw new ValidationException("In Range constraint, min or max must be set.");
        }
        if (this.min >= this.max) {
            throw new ValidationException("In Range constraint, min must be less than max.");
        }
    }

    @Override
    public String getMessage() {
        DecimalFormat decFormat = new DecimalFormat("#.##");
        decFormat.setDecimalSeparatorAlwaysShown(false);
        StringBuilder message = new StringBuilder();
        message.append("must be");
        if (this.min > -1.7976931348623157E308) {
            message.append(" at least ").append(decFormat.format(this.min));
        }
        if (this.max < Double.MAX_VALUE) {
            message.append(" at most ").append(decFormat.format(this.max));
        }
        message.append(".");
        return message.toString();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        try {
            double number = NumberFormat.getInstance().parse(value.toString()).doubleValue();
            return number >= this.min && number <= this.max;
        }
        catch (ParseException e) {
            if (this.isVariableType) {
                return true;
            }
            throw new ValidationException("Cannot get a number from {0}.", value.getClass().getSimpleName(), null);
        }
    }
}

