/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.validators;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class ObjectTypeValidator
implements ConstraintValidator<ObjectType, Object> {
    private ObjectType.Schema schema;
    private Class<?>[] baseClass;
    private Class<?> keyClass;
    private int maxSize;
    private int maxInnerSize;
    private int maxChecks;
    private boolean allowNull;
    private boolean allowInnerNull;

    @Override
    public void initialize(ObjectType annotation) {
        this.schema = annotation.schema();
        this.baseClass = (Class[])annotation.baseClass().clone();
        this.keyClass = annotation.keyClass();
        this.maxSize = annotation.maxSize();
        this.maxInnerSize = annotation.maxInnerSize();
        this.maxChecks = annotation.maxChecks();
        this.allowNull = annotation.allowNull();
        this.allowInnerNull = annotation.allowInnerNull();
    }

    @Override
    public String getMessage() {
        StringBuilder plainBaseClass = new StringBuilder();
        for (int i = 0; i < this.baseClass.length; ++i) {
            plainBaseClass.append(this.baseClass[i].getSimpleName());
            if (i >= this.baseClass.length - 1) continue;
            plainBaseClass.append("|");
        }
        StringBuilder message = new StringBuilder("type must be one of ");
        switch (this.schema) {
            case DIRECT: {
                message.append((CharSequence)plainBaseClass);
                break;
            }
            case COLL: {
                message.append("Collection<").append((CharSequence)plainBaseClass).append(">");
                break;
            }
            case COLL_COLL: {
                message.append("Collection<Collection<").append((CharSequence)plainBaseClass).append(">>");
                break;
            }
            case MAP: {
                message.append("Map<").append(this.keyClass.getSimpleName()).append(", ").append((CharSequence)plainBaseClass).append(">");
                break;
            }
            case MAP_COLL: {
                message.append("Map<").append(this.keyClass.getSimpleName()).append(", Collection<").append((CharSequence)plainBaseClass).append(">>");
            }
        }
        if (this.maxSize != Integer.MAX_VALUE) {
            message.append(" and size at most ").append(this.maxSize);
        }
        if (this.maxInnerSize != Integer.MAX_VALUE) {
            message.append(" and inner size at most ").append(this.maxInnerSize);
        }
        if (!this.allowNull) {
            message.append(" and not contain nulls");
        }
        if (!this.allowInnerNull) {
            message.append(" and not contain inner nulls");
        }
        message.append(".");
        return message.toString();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        switch (this.schema) {
            case DIRECT: {
                return this.isValidDirect(value);
            }
            case COLL: {
                return this.isValidCollection(value);
            }
            case COLL_COLL: {
                return this.isValidCollectionOfCollections(value);
            }
            case MAP: {
                return this.isValidMap(value);
            }
            case MAP_COLL: {
                return this.isValidMapOfCollections(value);
            }
        }
        return false;
    }

    private boolean isValidDirect(Object value) {
        return this.isInstanceOfAny(value, this.baseClass);
    }

    private boolean isValidCollection(Object value) {
        if (!(value instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)value;
        if (collection.size() > this.maxSize) {
            return false;
        }
        int checked = 0;
        for (Object item : collection) {
            if (checked >= this.maxChecks) break;
            if (item == null ? !this.allowNull : !this.isInstanceOfAny(item, this.baseClass)) {
                return false;
            }
            ++checked;
        }
        return true;
    }

    private boolean isValidCollectionOfCollections(Object value) {
        if (!(value instanceof Collection)) {
            return false;
        }
        Collection outerCollection = (Collection)value;
        if (outerCollection.size() > this.maxSize) {
            return false;
        }
        return this.validateCollectionItems(outerCollection, this::isValidInnerCollection);
    }

    private boolean isValidInnerCollection(Object item) {
        if (item == null) {
            return this.allowNull;
        }
        if (!(item instanceof Collection)) {
            return false;
        }
        Collection innerCollection = (Collection)item;
        if (innerCollection.size() > this.maxInnerSize) {
            return false;
        }
        return this.validateCollectionItems(innerCollection, this::isValidInnerItem);
    }

    private boolean isValidInnerItem(Object item) {
        if (item == null) {
            return this.allowInnerNull;
        }
        return this.isInstanceOfAny(item, this.baseClass);
    }

    private boolean isValidMap(Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map map = (Map)value;
        if (map.size() > this.maxSize) {
            return false;
        }
        return this.validateMapEntries(map, this::isValidMapValue);
    }

    private boolean isValidMapValue(Object value) {
        if (value == null) {
            return this.allowNull;
        }
        return this.isInstanceOfAny(value, this.baseClass);
    }

    private boolean isValidMapOfCollections(Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map map = (Map)value;
        if (map.size() > this.maxSize) {
            return false;
        }
        return this.validateMapEntries(map, this::isValidMapCollectionValue);
    }

    private boolean isValidMapCollectionValue(Object value) {
        if (value == null) {
            return this.allowNull;
        }
        if (!(value instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)value;
        if (collection.size() > this.maxInnerSize) {
            return false;
        }
        return this.validateCollectionItems(collection, this::isValidInnerItem);
    }

    private boolean validateCollectionItems(Collection<?> collection, Predicate<Object> validator) {
        int checked = 0;
        for (Object item : collection) {
            if (checked >= this.maxChecks) break;
            if (!validator.test(item)) {
                return false;
            }
            ++checked;
        }
        return true;
    }

    private boolean validateMapEntries(Map<?, ?> map, Predicate<Object> valueValidator) {
        int checked = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (checked >= this.maxChecks) break;
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.keyClass != Void.TYPE && key != null && !this.keyClass.isInstance(key)) {
                return false;
            }
            if (!valueValidator.test(val)) {
                return false;
            }
            ++checked;
        }
        return true;
    }

    private boolean isInstanceOfAny(Object value, Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isInstance(value)) continue;
            return true;
        }
        return false;
    }
}

