/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.validators;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.constraints.Extension;
import io.github.sashirestela.slimvalidator.exception.ValidationException;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;

public class ExtensionValidator
implements ConstraintValidator<Extension, Object> {
    private String[] extensions;

    @Override
    public void initialize(Extension annotation) {
        this.extensions = (String[])annotation.value().clone();
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append("extension must be one of ").append(Arrays.toString(this.extensions));
        return message.toString();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        return Arrays.stream(this.extensions).anyMatch(ext -> ext.equals(this.getExtension(value)));
    }

    private String getExtension(Object value) throws IllegalArgumentException {
        String fileName;
        if (value instanceof File) {
            fileName = ((File)value).getName();
        } else if (value instanceof Path) {
            fileName = ((Path)value).getFileName().toString();
        } else {
            throw new ValidationException("Object must be a File or Path.");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new ValidationException("File name is null or empty.");
        }
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex == -1 || lastDotIndex == 0 || lastDotIndex == fileName.length() - 1) {
            throw new ValidationException("No valid file extension found.");
        }
        return fileName.substring(lastDotIndex + 1);
    }
}

