/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator;

import io.github.sashirestela.slimvalidator.metadata.ClassMetadata;
import io.github.sashirestela.slimvalidator.util.Common;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConstraintViolation {
    private final Object value;
    private final String name;
    private final ClassMetadata.AnnotationMetadata annotationMetadata;

    public ConstraintViolation(Object value, String name, ClassMetadata.AnnotationMetadata annotationMetadata) {
        this.value = value;
        this.name = name;
        this.annotationMetadata = annotationMetadata;
    }

    public Object getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        String TMPL_LOOP = "#for(";
        String TMPL_CONDITION = "#if(";
        Map<String, Object> values = this.annotationMetadata.getValuesByAnnotMethod();
        String message = values.get("message").toString();
        if (message.contains("#for(")) {
            return this.replaceLoop(message, this.getSubMessages(this.annotationMetadata));
        }
        if (message.contains("#if(")) {
            return this.replaceCondition(message, values);
        }
        return this.replaceValues(message, values);
    }

    private List<String> getSubMessages(ClassMetadata.AnnotationMetadata annotationMetadata) {
        ArrayList<String> subMessages = new ArrayList<String>();
        List<ClassMetadata.AnnotationMetadata> subAnnotations = annotationMetadata.getSubAnnotations();
        for (ClassMetadata.AnnotationMetadata subAnnotation : subAnnotations) {
            ConstraintViolation subViolation = new ConstraintViolation(null, null, subAnnotation);
            String subMessage = subViolation.getMessage();
            subMessages.add(subMessage);
        }
        return subMessages;
    }

    private String replaceLoop(String message, List<String> subMessages) {
        String REGEX_LOOP = "#for\\(([^\\)]+)\\)([^#]+)#endfor";
        int LOOP_BODY = 2;
        Pattern pattern = Pattern.compile("#for\\(([^\\)]+)\\)([^#]+)#endfor");
        Matcher matcher = pattern.matcher(message);
        return matcher.replaceFirst(mr -> {
            StringBuilder replacement = new StringBuilder();
            for (String subMessage : subMessages) {
                Map<String, Object> values = Map.of("message", subMessage);
                replacement.append(this.replaceValues(mr.group(2), values));
            }
            return replacement.toString();
        });
    }

    private String replaceCondition(String message, Map<String, Object> values) {
        String REGEX_CONDITION = "#if\\(([^\\)]+)\\)([^#]+)#endif";
        boolean VARIABLE_NAME = true;
        int CONDITION_BODY = 2;
        Pattern pattern = Pattern.compile("#if\\(([^\\)]+)\\)([^#]+)#endif");
        Matcher matcher = pattern.matcher(message);
        String newMessage = matcher.replaceAll(mr -> {
            String replacement = "";
            Object object = values.get(mr.group(1));
            if (Common.existsByAnnotMethodType(object)) {
                replacement = mr.group(2);
            }
            return replacement;
        });
        return this.replaceValues(newMessage, values);
    }

    private String replaceValues(String message, Map<String, Object> values) {
        String REGEX_VARIABLE = "\\{([^}]+)\\}";
        boolean VARIABLE_NAME = true;
        Pattern pattern = Pattern.compile("\\{([^}]+)\\}");
        Matcher matcher = pattern.matcher(message);
        return matcher.replaceAll(mr -> {
            Object object = values.get(mr.group(1));
            return Common.toStringByAnnotMethodType(object);
        });
    }
}

