/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.common.function.SchemaConverter;
import java.lang.reflect.Type;

public class DefaultSchemaConverter
implements SchemaConverter {
    private final SchemaGenerator schemaGenerator;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public DefaultSchemaConverter() {
        JacksonModule jacksonModule = new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED, JacksonOption.RESPECT_JSONPROPERTY_ORDER});
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)jacksonModule).without(Option.SCHEMA_VERSION_INDICATOR, new Option[0]);
        SchemaGeneratorConfig config = configBuilder.build();
        this.schemaGenerator = new SchemaGenerator(config);
    }

    @Override
    public JsonNode convert(Class<?> clazz) {
        ObjectNode jsonSchema;
        try {
            jsonSchema = this.schemaGenerator.generateSchema(clazz, new Type[0]);
            if (jsonSchema.get("properties") == null) {
                jsonSchema = this.objectMapper.readTree("{\"type\":\"object\",\"properties\":{}}");
            }
        }
        catch (Exception e) {
            throw new SimpleUncheckedException("Cannot generate the Json Schema for the class {0}.", clazz.getName(), e);
        }
        return jsonSchema;
    }
}

