/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.ChunkingStrategy;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class VectorStoreFileBatchRequest {
    @Required
    @Size(min=1, max=500)
    private List<String> fileIds;
    private ChunkingStrategy chunkingStrategy;

    VectorStoreFileBatchRequest(List<String> fileIds, ChunkingStrategy chunkingStrategy) {
        this.fileIds = fileIds;
        this.chunkingStrategy = chunkingStrategy;
    }

    public static VectorStoreFileBatchRequestBuilder builder() {
        return new VectorStoreFileBatchRequestBuilder();
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public ChunkingStrategy getChunkingStrategy() {
        return this.chunkingStrategy;
    }

    public static class VectorStoreFileBatchRequestBuilder {
        private ArrayList<String> fileIds;
        private ChunkingStrategy chunkingStrategy;

        VectorStoreFileBatchRequestBuilder() {
        }

        public VectorStoreFileBatchRequestBuilder fileId(String fileId) {
            if (this.fileIds == null) {
                this.fileIds = new ArrayList();
            }
            this.fileIds.add(fileId);
            return this;
        }

        public VectorStoreFileBatchRequestBuilder fileIds(Collection<? extends String> fileIds) {
            if (fileIds == null) {
                throw new NullPointerException("fileIds cannot be null");
            }
            if (this.fileIds == null) {
                this.fileIds = new ArrayList();
            }
            this.fileIds.addAll(fileIds);
            return this;
        }

        public VectorStoreFileBatchRequestBuilder clearFileIds() {
            if (this.fileIds != null) {
                this.fileIds.clear();
            }
            return this;
        }

        public VectorStoreFileBatchRequestBuilder chunkingStrategy(ChunkingStrategy chunkingStrategy) {
            this.chunkingStrategy = chunkingStrategy;
            return this;
        }

        public VectorStoreFileBatchRequest build() {
            List<String> fileIds;
            switch (this.fileIds == null ? 0 : this.fileIds.size()) {
                case 0: {
                    fileIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    fileIds = Collections.singletonList(this.fileIds.get(0));
                    break;
                }
                default: {
                    fileIds = Collections.unmodifiableList(new ArrayList<String>(this.fileIds));
                }
            }
            return new VectorStoreFileBatchRequest(fileIds, this.chunkingStrategy);
        }

        public String toString() {
            return "VectorStoreFileBatchRequest.VectorStoreFileBatchRequestBuilder(fileIds=" + this.fileIds + ", chunkingStrategy=" + this.chunkingStrategy + ")";
        }
    }
}

