/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.common.tool;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.sashirestela.openai.common.function.FunctionDef;
import io.github.sashirestela.openai.common.tool.ToolType;
import io.github.sashirestela.openai.support.JsonSchemaUtil;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Tool {
    protected ToolType type;
    protected ToolFunctionDef function;

    public static Tool function(FunctionDef function) {
        return new Tool(ToolType.FUNCTION, new ToolFunctionDef(function.getName(), function.getDescription(), JsonSchemaUtil.classToJsonSchema(function.getFunctionalClass())));
    }

    public Tool(ToolType type, ToolFunctionDef function) {
        this.type = type;
        this.function = function;
    }

    public Tool() {
    }

    public ToolType getType() {
        return this.type;
    }

    public ToolFunctionDef getFunction() {
        return this.function;
    }

    public String toString() {
        return "Tool(type=" + this.getType() + ", function=" + this.getFunction() + ")";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ToolFunctionDef {
        @Required
        @Size(max=64)
        private String name;
        private String description;
        @Required
        private JsonNode parameters;

        public ToolFunctionDef(String name, String description, JsonNode parameters) {
            this.name = name;
            this.description = description;
            this.parameters = parameters;
        }

        public ToolFunctionDef() {
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public JsonNode getParameters() {
            return this.parameters;
        }

        public String toString() {
            return "Tool.ToolFunctionDef(name=" + this.getName() + ", description=" + this.getDescription() + ", parameters=" + this.getParameters() + ")";
        }
    }
}

