/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.moderation;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ModerationRequest {
    @Required
    private List<String> input;
    private String model;

    ModerationRequest(List<String> input, String model) {
        this.input = input;
        this.model = model;
    }

    public static ModerationRequestBuilder builder() {
        return new ModerationRequestBuilder();
    }

    public List<String> getInput() {
        return this.input;
    }

    public String getModel() {
        return this.model;
    }

    public static class ModerationRequestBuilder {
        private List<String> input;
        private String model;

        ModerationRequestBuilder() {
        }

        public ModerationRequestBuilder input(List<String> input) {
            this.input = input;
            return this;
        }

        public ModerationRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ModerationRequest build() {
            return new ModerationRequest(this.input, this.model);
        }

        public String toString() {
            return "ModerationRequest.ModerationRequestBuilder(input=" + this.input + ", model=" + this.model + ")";
        }
    }
}

