/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.image;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.sashirestela.openai.domain.image.AbstractImageRequest;
import io.github.sashirestela.slimvalidator.constraints.Extension;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.nio.file.Path;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ImageEditsRequest
extends AbstractImageRequest {
    @Required
    @Extension(value={"png"})
    private Path image;
    @Required
    private String prompt;
    @Extension(value={"png"})
    private Path mask;

    protected ImageEditsRequest(ImageEditsRequestBuilder<?, ?> b) {
        super(b);
        this.image = b.image;
        this.prompt = b.prompt;
        this.mask = b.mask;
    }

    public static ImageEditsRequestBuilder<?, ?> builder() {
        return new ImageEditsRequestBuilderImpl();
    }

    public Path getImage() {
        return this.image;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Path getMask() {
        return this.mask;
    }

    private static final class ImageEditsRequestBuilderImpl
    extends ImageEditsRequestBuilder<ImageEditsRequest, ImageEditsRequestBuilderImpl> {
        private ImageEditsRequestBuilderImpl() {
        }

        @Override
        protected ImageEditsRequestBuilderImpl self() {
            return this;
        }

        @Override
        public ImageEditsRequest build() {
            return new ImageEditsRequest(this);
        }
    }

    public static abstract class ImageEditsRequestBuilder<C extends ImageEditsRequest, B extends ImageEditsRequestBuilder<C, B>>
    extends AbstractImageRequest.AbstractImageRequestBuilder<C, B> {
        private Path image;
        private String prompt;
        private Path mask;

        public B image(Path image) {
            this.image = image;
            return (B)this.self();
        }

        public B prompt(String prompt) {
            this.prompt = prompt;
            return (B)this.self();
        }

        public B mask(Path mask) {
            this.mask = mask;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ImageEditsRequest.ImageEditsRequestBuilder(super=" + super.toString() + ", image=" + this.image + ", prompt=" + this.prompt + ", mask=" + this.mask + ")";
        }
    }
}

