/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.ResponseFormat;
import io.github.sashirestela.openai.common.StreamOptions;
import io.github.sashirestela.openai.common.tool.Tool;
import io.github.sashirestela.openai.common.tool.ToolChoice;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.domain.chat.ChatMessage;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ChatRequest {
    @Required
    private List<ChatMessage> messages;
    @Required
    private String model;
    @Range(min=-2.0, max=2.0)
    private Double frequencyPenalty;
    private Map<String, Integer> logitBias;
    private Boolean logprobs;
    @Range(min=0.0, max=20.0)
    private Integer topLogprobs;
    private Integer maxTokens;
    @Range(min=1.0, max=128.0)
    private Integer n;
    @Range(min=-2.0, max=2.0)
    private Double presencePenalty;
    private ResponseFormat responseFormat;
    private Integer seed;
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=String.class, firstGroup=true, maxSize=4)})
    private Object stop;
    private Boolean stream;
    private StreamOptions streamOptions;
    @Range(min=0.0, max=2.0)
    private Double temperature;
    @Range(min=0.0, max=1.0)
    private Double topP;
    private List<Tool> tools;
    @ObjectType.List(value={@ObjectType(baseClass=ToolChoiceOption.class), @ObjectType(baseClass=ToolChoice.class)})
    private Object toolChoice;
    private Boolean parallelToolCalls;
    private String user;

    ChatRequest(List<ChatMessage> messages, String model, Double frequencyPenalty, Map<String, Integer> logitBias, Boolean logprobs, Integer topLogprobs, Integer maxTokens, Integer n, Double presencePenalty, ResponseFormat responseFormat, Integer seed, Object stop, Boolean stream, StreamOptions streamOptions, Double temperature, Double topP, List<Tool> tools, Object toolChoice, Boolean parallelToolCalls, String user) {
        this.messages = messages;
        this.model = model;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.logprobs = logprobs;
        this.topLogprobs = topLogprobs;
        this.maxTokens = maxTokens;
        this.n = n;
        this.presencePenalty = presencePenalty;
        this.responseFormat = responseFormat;
        this.seed = seed;
        this.stop = stop;
        this.stream = stream;
        this.streamOptions = streamOptions;
        this.temperature = temperature;
        this.topP = topP;
        this.tools = tools;
        this.toolChoice = toolChoice;
        this.parallelToolCalls = parallelToolCalls;
        this.user = user;
    }

    public static ChatRequestBuilder builder() {
        return new ChatRequestBuilder();
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public String getModel() {
        return this.model;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public Object getStop() {
        return this.stop;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public String getUser() {
        return this.user;
    }

    public ChatRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new ChatRequest(this.messages, this.model, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.n, this.presencePenalty, this.responseFormat, this.seed, this.stop, stream, this.streamOptions, this.temperature, this.topP, this.tools, this.toolChoice, this.parallelToolCalls, this.user);
    }

    public ChatRequest withStreamOptions(StreamOptions streamOptions) {
        return this.streamOptions == streamOptions ? this : new ChatRequest(this.messages, this.model, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.n, this.presencePenalty, this.responseFormat, this.seed, this.stop, this.stream, streamOptions, this.temperature, this.topP, this.tools, this.toolChoice, this.parallelToolCalls, this.user);
    }

    public ChatRequest withToolChoice(Object toolChoice) {
        return this.toolChoice == toolChoice ? this : new ChatRequest(this.messages, this.model, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.n, this.presencePenalty, this.responseFormat, this.seed, this.stop, this.stream, this.streamOptions, this.temperature, this.topP, this.tools, toolChoice, this.parallelToolCalls, this.user);
    }

    public static class ChatRequestBuilder {
        private ArrayList<ChatMessage> messages;
        private String model;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private Boolean logprobs;
        private Integer topLogprobs;
        private Integer maxTokens;
        private Integer n;
        private Double presencePenalty;
        private ResponseFormat responseFormat;
        private Integer seed;
        private Object stop;
        private Boolean stream;
        private StreamOptions streamOptions;
        private Double temperature;
        private Double topP;
        private ArrayList<Tool> tools;
        private Object toolChoice;
        private Boolean parallelToolCalls;
        private String user;

        ChatRequestBuilder() {
        }

        public ChatRequestBuilder message(ChatMessage message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        public ChatRequestBuilder messages(Collection<? extends ChatMessage> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        public ChatRequestBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        public ChatRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ChatRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public ChatRequestBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public ChatRequestBuilder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public ChatRequestBuilder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public ChatRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public ChatRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public ChatRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public ChatRequestBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public ChatRequestBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public ChatRequestBuilder stop(Object stop) {
            this.stop = stop;
            return this;
        }

        public ChatRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public ChatRequestBuilder streamOptions(StreamOptions streamOptions) {
            this.streamOptions = streamOptions;
            return this;
        }

        public ChatRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ChatRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ChatRequestBuilder tool(Tool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        public ChatRequestBuilder tools(Collection<? extends Tool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        public ChatRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        public ChatRequestBuilder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public ChatRequestBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public ChatRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ChatRequest build() {
            List<Tool> tools;
            List<ChatMessage> messages;
            switch (this.messages == null ? 0 : this.messages.size()) {
                case 0: {
                    messages = Collections.emptyList();
                    break;
                }
                case 1: {
                    messages = Collections.singletonList(this.messages.get(0));
                    break;
                }
                default: {
                    messages = Collections.unmodifiableList(new ArrayList<ChatMessage>(this.messages));
                }
            }
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<Tool>(this.tools));
                }
            }
            return new ChatRequest(messages, this.model, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.n, this.presencePenalty, this.responseFormat, this.seed, this.stop, this.stream, this.streamOptions, this.temperature, this.topP, tools, this.toolChoice, this.parallelToolCalls, this.user);
        }

        public String toString() {
            return "ChatRequest.ChatRequestBuilder(messages=" + this.messages + ", model=" + this.model + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", logprobs=" + this.logprobs + ", topLogprobs=" + this.topLogprobs + ", maxTokens=" + this.maxTokens + ", n=" + this.n + ", presencePenalty=" + this.presencePenalty + ", responseFormat=" + this.responseFormat + ", seed=" + this.seed + ", stop=" + this.stop + ", stream=" + this.stream + ", streamOptions=" + this.streamOptions + ", temperature=" + this.temperature + ", topP=" + this.topP + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ", parallelToolCalls=" + this.parallelToolCalls + ", user=" + this.user + ")";
        }
    }
}

