/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ChunkingStrategy {
    private ChunkingStrategyType type;
    @JsonProperty(value="static")
    private StaticChunking staticChunking;

    private ChunkingStrategy(ChunkingStrategyType type, StaticChunking staticChunking) {
        this.type = type;
        this.staticChunking = staticChunking;
    }

    public static ChunkingStrategy autoType() {
        return new ChunkingStrategy(ChunkingStrategyType.AUTO, null);
    }

    public static ChunkingStrategy staticType(StaticChunking staticChunking) {
        return new ChunkingStrategy(ChunkingStrategyType.STATIC, staticChunking);
    }

    public ChunkingStrategy() {
    }

    public ChunkingStrategyType getType() {
        return this.type;
    }

    public StaticChunking getStaticChunking() {
        return this.staticChunking;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class StaticChunking {
        @Required
        @Range(min=100.0, max=4096.0)
        private Integer maxChunkSizeTokens;
        @Required
        @Range(max=2048.0)
        private Integer chunkOverlapTokens;

        StaticChunking(Integer maxChunkSizeTokens, Integer chunkOverlapTokens) {
            this.maxChunkSizeTokens = maxChunkSizeTokens;
            this.chunkOverlapTokens = chunkOverlapTokens;
        }

        public static StaticChunkingBuilder builder() {
            return new StaticChunkingBuilder();
        }

        public Integer getMaxChunkSizeTokens() {
            return this.maxChunkSizeTokens;
        }

        public Integer getChunkOverlapTokens() {
            return this.chunkOverlapTokens;
        }

        public static class StaticChunkingBuilder {
            private Integer maxChunkSizeTokens;
            private Integer chunkOverlapTokens;

            StaticChunkingBuilder() {
            }

            public StaticChunkingBuilder maxChunkSizeTokens(Integer maxChunkSizeTokens) {
                this.maxChunkSizeTokens = maxChunkSizeTokens;
                return this;
            }

            public StaticChunkingBuilder chunkOverlapTokens(Integer chunkOverlapTokens) {
                this.chunkOverlapTokens = chunkOverlapTokens;
                return this;
            }

            public StaticChunking build() {
                return new StaticChunking(this.maxChunkSizeTokens, this.chunkOverlapTokens);
            }

            public String toString() {
                return "ChunkingStrategy.StaticChunking.StaticChunkingBuilder(maxChunkSizeTokens=" + this.maxChunkSizeTokens + ", chunkOverlapTokens=" + this.chunkOverlapTokens + ")";
            }
        }
    }

    public static enum ChunkingStrategyType {
        AUTO,
        STATIC,
        OTHER;

    }
}

