/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class SpeechRequest {
    @Required
    private String model;
    @Required
    @Size(max=4096)
    private String input;
    @Required
    private Voice voice;
    private SpeechResponseFormat responseFormat;
    @Range(min=0.25, max=4.0)
    private Double speed;

    SpeechRequest(String model, String input, Voice voice, SpeechResponseFormat responseFormat, Double speed) {
        this.model = model;
        this.input = input;
        this.voice = voice;
        this.responseFormat = responseFormat;
        this.speed = speed;
    }

    public static SpeechRequestBuilder builder() {
        return new SpeechRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public String getInput() {
        return this.input;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public SpeechResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public static class SpeechRequestBuilder {
        private String model;
        private String input;
        private Voice voice;
        private SpeechResponseFormat responseFormat;
        private Double speed;

        SpeechRequestBuilder() {
        }

        public SpeechRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public SpeechRequestBuilder input(String input) {
            this.input = input;
            return this;
        }

        public SpeechRequestBuilder voice(Voice voice) {
            this.voice = voice;
            return this;
        }

        public SpeechRequestBuilder responseFormat(SpeechResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public SpeechRequestBuilder speed(Double speed) {
            this.speed = speed;
            return this;
        }

        public SpeechRequest build() {
            return new SpeechRequest(this.model, this.input, this.voice, this.responseFormat, this.speed);
        }

        public String toString() {
            return "SpeechRequest.SpeechRequestBuilder(model=" + this.model + ", input=" + this.input + ", voice=" + this.voice + ", responseFormat=" + this.responseFormat + ", speed=" + this.speed + ")";
        }
    }

    public static enum SpeechResponseFormat {
        MP3,
        OPUS,
        AAC,
        FLAC,
        WAV,
        PCM;

    }

    public static enum Voice {
        ALLOY,
        ECHO,
        FABLE,
        ONYX,
        NOVA,
        SHIMMER;

    }
}

