/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.audio.AudioResponseFormat;
import io.github.sashirestela.slimvalidator.constraints.Extension;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.nio.file.Path;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class TranslationRequest {
    @Required
    @Extension(value={"flac", "mp3", "mp4", "mpeg", "mpga", "m4a", "ogg", "wav", "webm"})
    private Path file;
    @Required
    private String model;
    private String prompt;
    private AudioResponseFormat responseFormat;
    @Range(min=0.0, max=1.0)
    private Double temperature;

    @Generated
    TranslationRequest(Path file, String model, String prompt, AudioResponseFormat responseFormat, Double temperature) {
        this.file = file;
        this.model = model;
        this.prompt = prompt;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
    }

    @Generated
    public static TranslationRequestBuilder builder() {
        return new TranslationRequestBuilder();
    }

    @Generated
    public Path getFile() {
        return this.file;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getPrompt() {
        return this.prompt;
    }

    @Generated
    public AudioResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public TranslationRequest withResponseFormat(AudioResponseFormat responseFormat) {
        return this.responseFormat == responseFormat ? this : new TranslationRequest(this.file, this.model, this.prompt, responseFormat, this.temperature);
    }

    @Generated
    public static class TranslationRequestBuilder {
        @Generated
        private Path file;
        @Generated
        private String model;
        @Generated
        private String prompt;
        @Generated
        private AudioResponseFormat responseFormat;
        @Generated
        private Double temperature;

        @Generated
        TranslationRequestBuilder() {
        }

        @Generated
        public TranslationRequestBuilder file(Path file) {
            this.file = file;
            return this;
        }

        @Generated
        public TranslationRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public TranslationRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @Generated
        public TranslationRequestBuilder responseFormat(AudioResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Generated
        public TranslationRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public TranslationRequest build() {
            return new TranslationRequest(this.file, this.model, this.prompt, this.responseFormat, this.temperature);
        }

        @Generated
        public String toString() {
            return "TranslationRequest.TranslationRequestBuilder(file=" + String.valueOf(this.file) + ", model=" + this.model + ", prompt=" + this.prompt + ", responseFormat=" + String.valueOf((Object)this.responseFormat) + ", temperature=" + this.temperature + ")";
        }
    }
}

