/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.content.ContentPart;
import io.github.sashirestela.openai.domain.assistant.Attachment;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageRole;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadMessageRequest {
    @Required
    private ThreadMessageRole role;
    @Required
    @ObjectType.ObjectTypes(value={@ObjectType(baseClass={String.class}), @ObjectType(schema=ObjectType.Schema.COLL, baseClass={ContentPart.class})})
    private Object content;
    private List<Attachment> attachments;
    @Size(max=16)
    private Map<String, String> metadata;

    @Generated
    ThreadMessageRequest(ThreadMessageRole role, Object content, List<Attachment> attachments, Map<String, String> metadata) {
        this.role = role;
        this.content = content;
        this.attachments = attachments;
        this.metadata = metadata;
    }

    @Generated
    public static ThreadMessageRequestBuilder builder() {
        return new ThreadMessageRequestBuilder();
    }

    @Generated
    public ThreadMessageRole getRole() {
        return this.role;
    }

    @Generated
    public Object getContent() {
        return this.content;
    }

    @Generated
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public static class ThreadMessageRequestBuilder {
        @Generated
        private ThreadMessageRole role;
        @Generated
        private Object content;
        @Generated
        private ArrayList<Attachment> attachments;
        @Generated
        private Map<String, String> metadata;

        @Generated
        ThreadMessageRequestBuilder() {
        }

        @Generated
        public ThreadMessageRequestBuilder role(ThreadMessageRole role) {
            this.role = role;
            return this;
        }

        @Generated
        public ThreadMessageRequestBuilder content(Object content) {
            this.content = content;
            return this;
        }

        @Generated
        public ThreadMessageRequestBuilder attachment(Attachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.add(attachment);
            return this;
        }

        @Generated
        public ThreadMessageRequestBuilder attachments(Collection<? extends Attachment> attachments) {
            if (attachments == null) {
                throw new NullPointerException("attachments cannot be null");
            }
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.addAll(attachments);
            return this;
        }

        @Generated
        public ThreadMessageRequestBuilder clearAttachments() {
            if (this.attachments != null) {
                this.attachments.clear();
            }
            return this;
        }

        @Generated
        public ThreadMessageRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public ThreadMessageRequest build() {
            List<Attachment> attachments;
            switch (this.attachments == null ? 0 : this.attachments.size()) {
                case 0: {
                    attachments = Collections.emptyList();
                    break;
                }
                case 1: {
                    attachments = Collections.singletonList(this.attachments.get(0));
                    break;
                }
                default: {
                    attachments = Collections.unmodifiableList(new ArrayList<Attachment>(this.attachments));
                }
            }
            return new ThreadMessageRequest(this.role, this.content, attachments, this.metadata);
        }

        @Generated
        public String toString() {
            return "ThreadMessageRequest.ThreadMessageRequestBuilder(role=" + String.valueOf((Object)this.role) + ", content=" + String.valueOf(this.content) + ", attachments=" + String.valueOf(this.attachments) + ", metadata=" + String.valueOf(this.metadata) + ")";
        }
    }
}

