/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.response.Input;
import io.github.sashirestela.openai.domain.response.Reasoning;
import io.github.sashirestela.openai.domain.response.ResponseText;
import io.github.sashirestela.openai.domain.response.ResponseTool;
import io.github.sashirestela.openai.domain.response.ResponseToolChoice;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ResponseRequest {
    @Required
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=Input.class, firstGroup=true)})
    private Object input;
    @Required
    private String model;
    private Boolean background;
    private List<ResponseInclude> include;
    private String instructions;
    private Long maxOutputTokens;
    @Size(max=16)
    private Map<String, String> metadata;
    private Boolean parallelToolCalls;
    private String previousResponseId;
    private Reasoning reasoning;
    private ChatRequest.ServiceTier serviceTier;
    private Boolean store;
    private Boolean stream;
    @Range(min=0.0, max=2.0)
    private Double temperature;
    private ResponseText text;
    @ObjectType.List(value={@ObjectType(baseClass=ToolChoiceOption.class), @ObjectType(baseClass=ResponseToolChoice.HostedTool.class), @ObjectType(baseClass=ResponseToolChoice.FunctionTool.class)})
    private Object toolChoice;
    private List<ResponseTool> tools;
    @Range(min=0.0, max=1.0)
    private Double topP;
    private Truncation truncation;
    private String user;

    @Generated
    public static ResponseRequestBuilder builder() {
        return new ResponseRequestBuilder();
    }

    @Generated
    public Object getInput() {
        return this.input;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public Boolean getBackground() {
        return this.background;
    }

    @Generated
    public List<ResponseInclude> getInclude() {
        return this.include;
    }

    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    @Generated
    public Long getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    @Generated
    public String getPreviousResponseId() {
        return this.previousResponseId;
    }

    @Generated
    public Reasoning getReasoning() {
        return this.reasoning;
    }

    @Generated
    public ChatRequest.ServiceTier getServiceTier() {
        return this.serviceTier;
    }

    @Generated
    public Boolean getStore() {
        return this.store;
    }

    @Generated
    public Boolean getStream() {
        return this.stream;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public ResponseText getText() {
        return this.text;
    }

    @Generated
    public Object getToolChoice() {
        return this.toolChoice;
    }

    @Generated
    public List<ResponseTool> getTools() {
        return this.tools;
    }

    @Generated
    public Double getTopP() {
        return this.topP;
    }

    @Generated
    public Truncation getTruncation() {
        return this.truncation;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public ResponseRequest(Object input, String model, Boolean background, List<ResponseInclude> include, String instructions, Long maxOutputTokens, Map<String, String> metadata, Boolean parallelToolCalls, String previousResponseId, Reasoning reasoning, ChatRequest.ServiceTier serviceTier, Boolean store, Boolean stream, Double temperature, ResponseText text, Object toolChoice, List<ResponseTool> tools, Double topP, Truncation truncation, String user) {
        this.input = input;
        this.model = model;
        this.background = background;
        this.include = include;
        this.instructions = instructions;
        this.maxOutputTokens = maxOutputTokens;
        this.metadata = metadata;
        this.parallelToolCalls = parallelToolCalls;
        this.previousResponseId = previousResponseId;
        this.reasoning = reasoning;
        this.serviceTier = serviceTier;
        this.store = store;
        this.stream = stream;
        this.temperature = temperature;
        this.text = text;
        this.toolChoice = toolChoice;
        this.tools = tools;
        this.topP = topP;
        this.truncation = truncation;
        this.user = user;
    }

    @Generated
    public ResponseRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new ResponseRequest(this.input, this.model, this.background, this.include, this.instructions, this.maxOutputTokens, this.metadata, this.parallelToolCalls, this.previousResponseId, this.reasoning, this.serviceTier, this.store, stream, this.temperature, this.text, this.toolChoice, this.tools, this.topP, this.truncation, this.user);
    }

    @Generated
    public static class ResponseRequestBuilder {
        @Generated
        private Object input;
        @Generated
        private String model;
        @Generated
        private Boolean background;
        @Generated
        private List<ResponseInclude> include;
        @Generated
        private String instructions;
        @Generated
        private Long maxOutputTokens;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private Boolean parallelToolCalls;
        @Generated
        private String previousResponseId;
        @Generated
        private Reasoning reasoning;
        @Generated
        private ChatRequest.ServiceTier serviceTier;
        @Generated
        private Boolean store;
        @Generated
        private Boolean stream;
        @Generated
        private Double temperature;
        @Generated
        private ResponseText text;
        @Generated
        private Object toolChoice;
        @Generated
        private ArrayList<ResponseTool> tools;
        @Generated
        private Double topP;
        @Generated
        private Truncation truncation;
        @Generated
        private String user;

        @Generated
        ResponseRequestBuilder() {
        }

        @Generated
        public ResponseRequestBuilder input(Object input) {
            this.input = input;
            return this;
        }

        @Generated
        public ResponseRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public ResponseRequestBuilder background(Boolean background) {
            this.background = background;
            return this;
        }

        @Generated
        public ResponseRequestBuilder include(List<ResponseInclude> include) {
            this.include = include;
            return this;
        }

        @Generated
        public ResponseRequestBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        @Generated
        public ResponseRequestBuilder maxOutputTokens(Long maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        @Generated
        public ResponseRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public ResponseRequestBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        @Generated
        public ResponseRequestBuilder previousResponseId(String previousResponseId) {
            this.previousResponseId = previousResponseId;
            return this;
        }

        @Generated
        public ResponseRequestBuilder reasoning(Reasoning reasoning) {
            this.reasoning = reasoning;
            return this;
        }

        @Generated
        public ResponseRequestBuilder serviceTier(ChatRequest.ServiceTier serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        @Generated
        public ResponseRequestBuilder store(Boolean store) {
            this.store = store;
            return this;
        }

        @Generated
        public ResponseRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public ResponseRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public ResponseRequestBuilder text(ResponseText text) {
            this.text = text;
            return this;
        }

        @Generated
        public ResponseRequestBuilder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @Generated
        public ResponseRequestBuilder tool(ResponseTool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        @Generated
        public ResponseRequestBuilder tools(Collection<? extends ResponseTool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        @Generated
        public ResponseRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        @Generated
        public ResponseRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public ResponseRequestBuilder truncation(Truncation truncation) {
            this.truncation = truncation;
            return this;
        }

        @Generated
        public ResponseRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public ResponseRequest build() {
            List<ResponseTool> tools;
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<ResponseTool>(this.tools));
                }
            }
            return new ResponseRequest(this.input, this.model, this.background, this.include, this.instructions, this.maxOutputTokens, this.metadata, this.parallelToolCalls, this.previousResponseId, this.reasoning, this.serviceTier, this.store, this.stream, this.temperature, this.text, this.toolChoice, tools, this.topP, this.truncation, this.user);
        }

        @Generated
        public String toString() {
            return "ResponseRequest.ResponseRequestBuilder(input=" + String.valueOf(this.input) + ", model=" + this.model + ", background=" + this.background + ", include=" + String.valueOf(this.include) + ", instructions=" + this.instructions + ", maxOutputTokens=" + this.maxOutputTokens + ", metadata=" + String.valueOf(this.metadata) + ", parallelToolCalls=" + this.parallelToolCalls + ", previousResponseId=" + this.previousResponseId + ", reasoning=" + String.valueOf(this.reasoning) + ", serviceTier=" + String.valueOf((Object)this.serviceTier) + ", store=" + this.store + ", stream=" + this.stream + ", temperature=" + this.temperature + ", text=" + String.valueOf(this.text) + ", toolChoice=" + String.valueOf(this.toolChoice) + ", tools=" + String.valueOf(this.tools) + ", topP=" + this.topP + ", truncation=" + String.valueOf((Object)this.truncation) + ", user=" + this.user + ")";
        }
    }

    public static enum Truncation {
        AUTO,
        DISABLED;

    }

    public static enum ResponseInclude {
        FILE_SEARCH_CALL_RESULTS,
        MESSAGE_INPUT_IMAGE_URL,
        COMPUTER_CALL_OUTPUT_IMAGE_URL,
        REASONING_ENCRYPTED_CONTENT,
        CODE_INTERPRETER_CALL_OUTPUTS;

    }
}

