/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ChunkingStrategy {
    private ChunkingStrategyType type;
    @JsonProperty(value="static")
    private StaticChunking staticChunking;

    private ChunkingStrategy(ChunkingStrategyType type, StaticChunking staticChunking) {
        this.type = type;
        this.staticChunking = staticChunking;
    }

    public static ChunkingStrategy autoType() {
        return new ChunkingStrategy(ChunkingStrategyType.AUTO, null);
    }

    public static ChunkingStrategy staticType(StaticChunking staticChunking) {
        return new ChunkingStrategy(ChunkingStrategyType.STATIC, staticChunking);
    }

    @Generated
    public ChunkingStrategy() {
    }

    @Generated
    public ChunkingStrategyType getType() {
        return this.type;
    }

    @Generated
    public StaticChunking getStaticChunking() {
        return this.staticChunking;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class StaticChunking {
        @Required
        @Range(min=100.0, max=4096.0)
        private Integer maxChunkSizeTokens;
        @Required
        @Range(max=2048.0)
        private Integer chunkOverlapTokens;

        @Generated
        public static StaticChunkingBuilder builder() {
            return new StaticChunkingBuilder();
        }

        @Generated
        public StaticChunking(Integer maxChunkSizeTokens, Integer chunkOverlapTokens) {
            this.maxChunkSizeTokens = maxChunkSizeTokens;
            this.chunkOverlapTokens = chunkOverlapTokens;
        }

        @Generated
        public StaticChunking() {
        }

        @Generated
        public Integer getMaxChunkSizeTokens() {
            return this.maxChunkSizeTokens;
        }

        @Generated
        public Integer getChunkOverlapTokens() {
            return this.chunkOverlapTokens;
        }

        @Generated
        public static class StaticChunkingBuilder {
            @Generated
            private Integer maxChunkSizeTokens;
            @Generated
            private Integer chunkOverlapTokens;

            @Generated
            StaticChunkingBuilder() {
            }

            @Generated
            public StaticChunkingBuilder maxChunkSizeTokens(Integer maxChunkSizeTokens) {
                this.maxChunkSizeTokens = maxChunkSizeTokens;
                return this;
            }

            @Generated
            public StaticChunkingBuilder chunkOverlapTokens(Integer chunkOverlapTokens) {
                this.chunkOverlapTokens = chunkOverlapTokens;
                return this;
            }

            @Generated
            public StaticChunking build() {
                return new StaticChunking(this.maxChunkSizeTokens, this.chunkOverlapTokens);
            }

            @Generated
            public String toString() {
                return "ChunkingStrategy.StaticChunking.StaticChunkingBuilder(maxChunkSizeTokens=" + this.maxChunkSizeTokens + ", chunkOverlapTokens=" + this.chunkOverlapTokens + ")";
            }
        }
    }

    public static enum ChunkingStrategyType {
        AUTO,
        STATIC,
        OTHER;

    }
}

