/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.content.ImageDetail;
import io.github.sashirestela.openai.domain.response.Action;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public abstract class Input {

    public static enum CitationType {
        FILE_CITATION,
        URL_CITATION,
        FILE_PATH;

    }

    public static enum SearchStatus {
        IN_PROGRESS,
        SEARCHING,
        COMPLETED,
        INCOMPLETE,
        FAILED;

    }

    public static enum ItemStatus {
        IN_PROGRESS,
        COMPLETED,
        INCOMPLETE;

    }

    public static enum OutputContentType {
        OUTPUT_TEXT,
        REFUSAL;

    }

    public static enum ContentType {
        INPUT_TEXT,
        INPUT_IMAGE,
        INPUT_FILE;

    }

    public static enum ItemType {
        MESSAGE,
        FILE_SEARCH_CALL,
        COMPUTER_CALL,
        COMPUTER_CALL_OUTPUT,
        WEB_SEARCH_CALL,
        FUNCTION_CALL,
        FUNCTION_CALL_OUTPUT,
        REASONING;

    }

    public static enum MessageRole {
        USER,
        ASSISTANT,
        SYSTEM,
        DEVELOPER;

    }

    public static enum InputType {
        MESSAGE,
        ITEM_REFERENCE;

    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ReasoningContent {
        @Required
        private String text;
        private String type;

        private ReasoningContent(String text) {
            this.text = text;
            this.type = "summary_text";
        }

        public static ReasoningContent of(String text) {
            return new ReasoningContent(text);
        }

        @Generated
        public ReasoningContent() {
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "Input.ReasoningContent(text=" + this.getText() + ", type=" + this.getType() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ScreenshotImage {
        private String fileId;
        private String imageUrl;
        private String type;

        public ScreenshotImage(String fileId, String imageUrl) {
            this.fileId = fileId;
            this.imageUrl = imageUrl;
            this.type = "computer_screenshot";
        }

        @Generated
        public static ScreenshotImageBuilder builder() {
            return new ScreenshotImageBuilder();
        }

        @Generated
        public ScreenshotImage() {
        }

        @Generated
        public String getFileId() {
            return this.fileId;
        }

        @Generated
        public String getImageUrl() {
            return this.imageUrl;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "Input.ScreenshotImage(fileId=" + this.getFileId() + ", imageUrl=" + this.getImageUrl() + ", type=" + this.getType() + ")";
        }

        @Generated
        public static class ScreenshotImageBuilder {
            @Generated
            private String fileId;
            @Generated
            private String imageUrl;

            @Generated
            ScreenshotImageBuilder() {
            }

            @Generated
            public ScreenshotImageBuilder fileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            @Generated
            public ScreenshotImageBuilder imageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            @Generated
            public ScreenshotImage build() {
                return new ScreenshotImage(this.fileId, this.imageUrl);
            }

            @Generated
            public String toString() {
                return "Input.ScreenshotImage.ScreenshotImageBuilder(fileId=" + this.fileId + ", imageUrl=" + this.imageUrl + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class SafetyCheck {
        @Required
        private String id;
        private String code;
        private String message;

        @Generated
        public static SafetyCheckBuilder builder() {
            return new SafetyCheckBuilder();
        }

        @Generated
        public SafetyCheck() {
        }

        @Generated
        public SafetyCheck(String id, String code, String message) {
            this.id = id;
            this.code = code;
            this.message = message;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String toString() {
            return "Input.SafetyCheck(id=" + this.getId() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ")";
        }

        @Generated
        public static class SafetyCheckBuilder {
            @Generated
            private String id;
            @Generated
            private String code;
            @Generated
            private String message;

            @Generated
            SafetyCheckBuilder() {
            }

            @Generated
            public SafetyCheckBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public SafetyCheckBuilder code(String code) {
                this.code = code;
                return this;
            }

            @Generated
            public SafetyCheckBuilder message(String message) {
                this.message = message;
                return this;
            }

            @Generated
            public SafetyCheck build() {
                return new SafetyCheck(this.id, this.code, this.message);
            }

            @Generated
            public String toString() {
                return "Input.SafetyCheck.SafetyCheckBuilder(id=" + this.id + ", code=" + this.code + ", message=" + this.message + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FileSearchResult {
        @Size(max=16)
        private Map<String, Object> attributes;
        private String fileId;
        private String filename;
        @Range(min=0.0, max=1.0)
        private Double score;
        private String text;

        @Generated
        public static FileSearchResultBuilder builder() {
            return new FileSearchResultBuilder();
        }

        @Generated
        public FileSearchResult() {
        }

        @Generated
        public FileSearchResult(Map<String, Object> attributes, String fileId, String filename, Double score, String text) {
            this.attributes = attributes;
            this.fileId = fileId;
            this.filename = filename;
            this.score = score;
            this.text = text;
        }

        @Generated
        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Generated
        public String getFileId() {
            return this.fileId;
        }

        @Generated
        public String getFilename() {
            return this.filename;
        }

        @Generated
        public Double getScore() {
            return this.score;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public String toString() {
            return "Input.FileSearchResult(attributes=" + String.valueOf(this.getAttributes()) + ", fileId=" + this.getFileId() + ", filename=" + this.getFilename() + ", score=" + this.getScore() + ", text=" + this.getText() + ")";
        }

        @Generated
        public static class FileSearchResultBuilder {
            @Generated
            private Map<String, Object> attributes;
            @Generated
            private String fileId;
            @Generated
            private String filename;
            @Generated
            private Double score;
            @Generated
            private String text;

            @Generated
            FileSearchResultBuilder() {
            }

            @Generated
            public FileSearchResultBuilder attributes(Map<String, Object> attributes) {
                this.attributes = attributes;
                return this;
            }

            @Generated
            public FileSearchResultBuilder fileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            @Generated
            public FileSearchResultBuilder filename(String filename) {
                this.filename = filename;
                return this;
            }

            @Generated
            public FileSearchResultBuilder score(Double score) {
                this.score = score;
                return this;
            }

            @Generated
            public FileSearchResultBuilder text(String text) {
                this.text = text;
                return this;
            }

            @Generated
            public FileSearchResult build() {
                return new FileSearchResult(this.attributes, this.fileId, this.filename, this.score, this.text);
            }

            @Generated
            public String toString() {
                return "Input.FileSearchResult.FileSearchResultBuilder(attributes=" + String.valueOf(this.attributes) + ", fileId=" + this.fileId + ", filename=" + this.filename + ", score=" + this.score + ", text=" + this.text + ")";
            }
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=FileCitation.class, name="file_citation"), @JsonSubTypes.Type(value=UrlCitation.class, name="url_citation"), @JsonSubTypes.Type(value=FilePath.class, name="file_path")})
    public static abstract class Citation {
        protected CitationType type;

        @Generated
        public CitationType getType() {
            return this.type;
        }

        @Generated
        public void setType(CitationType type) {
            this.type = type;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class FilePath
        extends Citation {
            @Required
            private String fileId;
            @Required
            private Integer index;

            private FilePath(String fileId, Integer index) {
                this.fileId = fileId;
                this.index = index;
                this.type = CitationType.FILE_PATH;
            }

            public static FilePath of(String fileId, Integer index) {
                return new FilePath(fileId, index);
            }

            @Generated
            public FilePath() {
            }

            @Generated
            public String getFileId() {
                return this.fileId;
            }

            @Generated
            public Integer getIndex() {
                return this.index;
            }

            @Generated
            public String toString() {
                return "Input.Citation.FilePath(fileId=" + this.getFileId() + ", index=" + this.getIndex() + ")";
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class UrlCitation
        extends Citation {
            @Required
            private Integer endIndex;
            @Required
            private Integer startIndex;
            @Required
            private String title;
            @Required
            private String url;

            public UrlCitation(Integer endIndex, Integer startIndex, String title, String url) {
                this.endIndex = endIndex;
                this.startIndex = startIndex;
                this.title = title;
                this.url = url;
                this.type = CitationType.URL_CITATION;
            }

            @Generated
            public static UrlCitationBuilder builder() {
                return new UrlCitationBuilder();
            }

            @Generated
            public UrlCitation() {
            }

            @Generated
            public Integer getEndIndex() {
                return this.endIndex;
            }

            @Generated
            public Integer getStartIndex() {
                return this.startIndex;
            }

            @Generated
            public String getTitle() {
                return this.title;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public String toString() {
                return "Input.Citation.UrlCitation(endIndex=" + this.getEndIndex() + ", startIndex=" + this.getStartIndex() + ", title=" + this.getTitle() + ", url=" + this.getUrl() + ")";
            }

            @Generated
            public static class UrlCitationBuilder {
                @Generated
                private Integer endIndex;
                @Generated
                private Integer startIndex;
                @Generated
                private String title;
                @Generated
                private String url;

                @Generated
                UrlCitationBuilder() {
                }

                @Generated
                public UrlCitationBuilder endIndex(Integer endIndex) {
                    this.endIndex = endIndex;
                    return this;
                }

                @Generated
                public UrlCitationBuilder startIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Generated
                public UrlCitationBuilder title(String title) {
                    this.title = title;
                    return this;
                }

                @Generated
                public UrlCitationBuilder url(String url) {
                    this.url = url;
                    return this;
                }

                @Generated
                public UrlCitation build() {
                    return new UrlCitation(this.endIndex, this.startIndex, this.title, this.url);
                }

                @Generated
                public String toString() {
                    return "Input.Citation.UrlCitation.UrlCitationBuilder(endIndex=" + this.endIndex + ", startIndex=" + this.startIndex + ", title=" + this.title + ", url=" + this.url + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class FileCitation
        extends Citation {
            @Required
            private String fileId;
            @Required
            private Integer index;
            @Required
            private String filename;

            public FileCitation(String fileId, Integer index, String filename) {
                this.fileId = fileId;
                this.index = index;
                this.filename = filename;
                this.type = CitationType.FILE_CITATION;
            }

            @Generated
            public static FileCitationBuilder builder() {
                return new FileCitationBuilder();
            }

            @Generated
            public FileCitation() {
            }

            @Generated
            public String getFileId() {
                return this.fileId;
            }

            @Generated
            public Integer getIndex() {
                return this.index;
            }

            @Generated
            public String getFilename() {
                return this.filename;
            }

            @Generated
            public String toString() {
                return "Input.Citation.FileCitation(fileId=" + this.getFileId() + ", index=" + this.getIndex() + ", filename=" + this.getFilename() + ")";
            }

            @Generated
            public static class FileCitationBuilder {
                @Generated
                private String fileId;
                @Generated
                private Integer index;
                @Generated
                private String filename;

                @Generated
                FileCitationBuilder() {
                }

                @Generated
                public FileCitationBuilder fileId(String fileId) {
                    this.fileId = fileId;
                    return this;
                }

                @Generated
                public FileCitationBuilder index(Integer index) {
                    this.index = index;
                    return this;
                }

                @Generated
                public FileCitationBuilder filename(String filename) {
                    this.filename = filename;
                    return this;
                }

                @Generated
                public FileCitation build() {
                    return new FileCitation(this.fileId, this.index, this.filename);
                }

                @Generated
                public String toString() {
                    return "Input.Citation.FileCitation.FileCitationBuilder(fileId=" + this.fileId + ", index=" + this.index + ", filename=" + this.filename + ")";
                }
            }
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextOutputContent.class, name="output_text"), @JsonSubTypes.Type(value=RefusalOutputContent.class, name="refusal")})
    public static abstract class OutputContent {
        protected OutputContentType type;

        @Generated
        public OutputContentType getType() {
            return this.type;
        }

        @Generated
        public void setType(OutputContentType type) {
            this.type = type;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class RefusalOutputContent
        extends OutputContent {
            private String refusal;

            private RefusalOutputContent(String refusal) {
                this.refusal = refusal;
                this.type = OutputContentType.REFUSAL;
            }

            public static RefusalOutputContent of(String refusal) {
                return new RefusalOutputContent(refusal);
            }

            @Generated
            public RefusalOutputContent() {
            }

            @Generated
            public String getRefusal() {
                return this.refusal;
            }

            @Generated
            public String toString() {
                return "Input.OutputContent.RefusalOutputContent(refusal=" + this.getRefusal() + ")";
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class TextOutputContent
        extends OutputContent {
            @Required
            private List<Citation> annotations;
            @Required
            private String text;

            private TextOutputContent(List<Citation> annotations, String text) {
                this.annotations = annotations;
                this.text = text;
                this.type = OutputContentType.OUTPUT_TEXT;
            }

            public static TextOutputContent of(List<Citation> annotations, String text) {
                return new TextOutputContent(annotations, text);
            }

            @Generated
            public TextOutputContent() {
            }

            @Generated
            public List<Citation> getAnnotations() {
                return this.annotations;
            }

            @Generated
            public String getText() {
                return this.text;
            }

            @Generated
            public String toString() {
                return "Input.OutputContent.TextOutputContent(annotations=" + String.valueOf(this.getAnnotations()) + ", text=" + this.getText() + ")";
            }
        }
    }

    public static abstract class Item
    extends Input {
        protected ItemType type;
        protected String id;

        @Generated
        public ItemType getType() {
            return this.type;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setType(ItemType type) {
            this.type = type;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class ReasoningItem
        extends Item {
            @Required
            private List<ReasoningContent> summary;
            private String encryptedContent;
            private ItemStatus status;

            public ReasoningItem(String id, List<ReasoningContent> summary, String encryptedContent, ItemStatus status) {
                this.id = id;
                this.summary = summary;
                this.encryptedContent = encryptedContent;
                this.status = status;
                this.type = ItemType.REASONING;
            }

            @Generated
            public static ReasoningItemBuilder builder() {
                return new ReasoningItemBuilder();
            }

            @Generated
            public ReasoningItem() {
            }

            @Generated
            public List<ReasoningContent> getSummary() {
                return this.summary;
            }

            @Generated
            public String getEncryptedContent() {
                return this.encryptedContent;
            }

            @Generated
            public ItemStatus getStatus() {
                return this.status;
            }

            @Generated
            public String toString() {
                return "Input.Item.ReasoningItem(summary=" + String.valueOf(this.getSummary()) + ", encryptedContent=" + this.getEncryptedContent() + ", status=" + String.valueOf((Object)this.getStatus()) + ")";
            }

            @Generated
            public static class ReasoningItemBuilder {
                @Generated
                private String id;
                @Generated
                private List<ReasoningContent> summary;
                @Generated
                private String encryptedContent;
                @Generated
                private ItemStatus status;

                @Generated
                ReasoningItemBuilder() {
                }

                @Generated
                public ReasoningItemBuilder id(String id) {
                    this.id = id;
                    return this;
                }

                @Generated
                public ReasoningItemBuilder summary(List<ReasoningContent> summary) {
                    this.summary = summary;
                    return this;
                }

                @Generated
                public ReasoningItemBuilder encryptedContent(String encryptedContent) {
                    this.encryptedContent = encryptedContent;
                    return this;
                }

                @Generated
                public ReasoningItemBuilder status(ItemStatus status) {
                    this.status = status;
                    return this;
                }

                @Generated
                public ReasoningItem build() {
                    return new ReasoningItem(this.id, this.summary, this.encryptedContent, this.status);
                }

                @Generated
                public String toString() {
                    return "Input.Item.ReasoningItem.ReasoningItemBuilder(id=" + this.id + ", summary=" + String.valueOf(this.summary) + ", encryptedContent=" + this.encryptedContent + ", status=" + String.valueOf((Object)this.status) + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class FunctionCallOutputItem
        extends Item {
            @Required
            private String callId;
            @Required
            private String output;
            private ItemStatus status;

            public FunctionCallOutputItem(String callId, String output, String id, ItemStatus status) {
                this.callId = callId;
                this.output = output;
                this.id = id;
                this.status = status;
                this.type = ItemType.FUNCTION_CALL_OUTPUT;
            }

            @Generated
            public static FunctionCallOutputItemBuilder builder() {
                return new FunctionCallOutputItemBuilder();
            }

            @Generated
            public FunctionCallOutputItem() {
            }

            @Generated
            public String getCallId() {
                return this.callId;
            }

            @Generated
            public String getOutput() {
                return this.output;
            }

            @Generated
            public ItemStatus getStatus() {
                return this.status;
            }

            @Generated
            public String toString() {
                return "Input.Item.FunctionCallOutputItem(callId=" + this.getCallId() + ", output=" + this.getOutput() + ", status=" + String.valueOf((Object)this.getStatus()) + ")";
            }

            @Generated
            public static class FunctionCallOutputItemBuilder {
                @Generated
                private String callId;
                @Generated
                private String output;
                @Generated
                private String id;
                @Generated
                private ItemStatus status;

                @Generated
                FunctionCallOutputItemBuilder() {
                }

                @Generated
                public FunctionCallOutputItemBuilder callId(String callId) {
                    this.callId = callId;
                    return this;
                }

                @Generated
                public FunctionCallOutputItemBuilder output(String output) {
                    this.output = output;
                    return this;
                }

                @Generated
                public FunctionCallOutputItemBuilder id(String id) {
                    this.id = id;
                    return this;
                }

                @Generated
                public FunctionCallOutputItemBuilder status(ItemStatus status) {
                    this.status = status;
                    return this;
                }

                @Generated
                public FunctionCallOutputItem build() {
                    return new FunctionCallOutputItem(this.callId, this.output, this.id, this.status);
                }

                @Generated
                public String toString() {
                    return "Input.Item.FunctionCallOutputItem.FunctionCallOutputItemBuilder(callId=" + this.callId + ", output=" + this.output + ", id=" + this.id + ", status=" + String.valueOf((Object)this.status) + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class FunctionCallItem
        extends Item {
            @Required
            private String arguments;
            @Required
            private String callId;
            @Required
            private String name;
            @Required
            private ItemStatus status;

            public FunctionCallItem(String arguments, String callId, String name, String id, ItemStatus status) {
                this.arguments = arguments;
                this.callId = callId;
                this.name = name;
                this.id = id;
                this.status = status;
                this.type = ItemType.FUNCTION_CALL;
            }

            @Generated
            public static FunctionCallItemBuilder builder() {
                return new FunctionCallItemBuilder();
            }

            @Generated
            public FunctionCallItem() {
            }

            @Generated
            public String getArguments() {
                return this.arguments;
            }

            @Generated
            public String getCallId() {
                return this.callId;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public ItemStatus getStatus() {
                return this.status;
            }

            @Generated
            public String toString() {
                return "Input.Item.FunctionCallItem(arguments=" + this.getArguments() + ", callId=" + this.getCallId() + ", name=" + this.getName() + ", status=" + String.valueOf((Object)this.getStatus()) + ")";
            }

            @Generated
            public static class FunctionCallItemBuilder {
                @Generated
                private String arguments;
                @Generated
                private String callId;
                @Generated
                private String name;
                @Generated
                private String id;
                @Generated
                private ItemStatus status;

                @Generated
                FunctionCallItemBuilder() {
                }

                @Generated
                public FunctionCallItemBuilder arguments(String arguments) {
                    this.arguments = arguments;
                    return this;
                }

                @Generated
                public FunctionCallItemBuilder callId(String callId) {
                    this.callId = callId;
                    return this;
                }

                @Generated
                public FunctionCallItemBuilder name(String name) {
                    this.name = name;
                    return this;
                }

                @Generated
                public FunctionCallItemBuilder id(String id) {
                    this.id = id;
                    return this;
                }

                @Generated
                public FunctionCallItemBuilder status(ItemStatus status) {
                    this.status = status;
                    return this;
                }

                @Generated
                public FunctionCallItem build() {
                    return new FunctionCallItem(this.arguments, this.callId, this.name, this.id, this.status);
                }

                @Generated
                public String toString() {
                    return "Input.Item.FunctionCallItem.FunctionCallItemBuilder(arguments=" + this.arguments + ", callId=" + this.callId + ", name=" + this.name + ", id=" + this.id + ", status=" + String.valueOf((Object)this.status) + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class WebSearchCallItem
        extends Item {
            @Required
            private SearchStatus status;

            public WebSearchCallItem(String id, SearchStatus status) {
                this.id = id;
                this.status = status;
                this.type = ItemType.WEB_SEARCH_CALL;
            }

            @Generated
            public static WebSearchCallItemBuilder builder() {
                return new WebSearchCallItemBuilder();
            }

            @Generated
            public WebSearchCallItem() {
            }

            @Generated
            public SearchStatus getStatus() {
                return this.status;
            }

            @Generated
            public String toString() {
                return "Input.Item.WebSearchCallItem(status=" + String.valueOf((Object)this.getStatus()) + ")";
            }

            @Generated
            public static class WebSearchCallItemBuilder {
                @Generated
                private String id;
                @Generated
                private SearchStatus status;

                @Generated
                WebSearchCallItemBuilder() {
                }

                @Generated
                public WebSearchCallItemBuilder id(String id) {
                    this.id = id;
                    return this;
                }

                @Generated
                public WebSearchCallItemBuilder status(SearchStatus status) {
                    this.status = status;
                    return this;
                }

                @Generated
                public WebSearchCallItem build() {
                    return new WebSearchCallItem(this.id, this.status);
                }

                @Generated
                public String toString() {
                    return "Input.Item.WebSearchCallItem.WebSearchCallItemBuilder(id=" + this.id + ", status=" + String.valueOf((Object)this.status) + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class ComputerCallOutputItem
        extends Item {
            @Required
            private String callId;
            @Required
            private ScreenshotImage output;
            private List<SafetyCheck> acknowledgedSafetyChecks;
            @Required
            private ItemStatus status;

            public ComputerCallOutputItem(String callId, ScreenshotImage output, List<SafetyCheck> acknowledgedSafetyChecks, String id, ItemStatus status) {
                this.callId = callId;
                this.output = output;
                this.acknowledgedSafetyChecks = acknowledgedSafetyChecks;
                this.id = id;
                this.status = status;
                this.type = ItemType.COMPUTER_CALL_OUTPUT;
            }

            @Generated
            public static ComputerCallOutputItemBuilder builder() {
                return new ComputerCallOutputItemBuilder();
            }

            @Generated
            public ComputerCallOutputItem() {
            }

            @Generated
            public String getCallId() {
                return this.callId;
            }

            @Generated
            public ScreenshotImage getOutput() {
                return this.output;
            }

            @Generated
            public List<SafetyCheck> getAcknowledgedSafetyChecks() {
                return this.acknowledgedSafetyChecks;
            }

            @Generated
            public ItemStatus getStatus() {
                return this.status;
            }

            @Generated
            public String toString() {
                return "Input.Item.ComputerCallOutputItem(callId=" + this.getCallId() + ", output=" + String.valueOf(this.getOutput()) + ", acknowledgedSafetyChecks=" + String.valueOf(this.getAcknowledgedSafetyChecks()) + ", status=" + String.valueOf((Object)this.getStatus()) + ")";
            }

            @Generated
            public static class ComputerCallOutputItemBuilder {
                @Generated
                private String callId;
                @Generated
                private ScreenshotImage output;
                @Generated
                private List<SafetyCheck> acknowledgedSafetyChecks;
                @Generated
                private String id;
                @Generated
                private ItemStatus status;

                @Generated
                ComputerCallOutputItemBuilder() {
                }

                @Generated
                public ComputerCallOutputItemBuilder callId(String callId) {
                    this.callId = callId;
                    return this;
                }

                @Generated
                public ComputerCallOutputItemBuilder output(ScreenshotImage output) {
                    this.output = output;
                    return this;
                }

                @Generated
                public ComputerCallOutputItemBuilder acknowledgedSafetyChecks(List<SafetyCheck> acknowledgedSafetyChecks) {
                    this.acknowledgedSafetyChecks = acknowledgedSafetyChecks;
                    return this;
                }

                @Generated
                public ComputerCallOutputItemBuilder id(String id) {
                    this.id = id;
                    return this;
                }

                @Generated
                public ComputerCallOutputItemBuilder status(ItemStatus status) {
                    this.status = status;
                    return this;
                }

                @Generated
                public ComputerCallOutputItem build() {
                    return new ComputerCallOutputItem(this.callId, this.output, this.acknowledgedSafetyChecks, this.id, this.status);
                }

                @Generated
                public String toString() {
                    return "Input.Item.ComputerCallOutputItem.ComputerCallOutputItemBuilder(callId=" + this.callId + ", output=" + String.valueOf(this.output) + ", acknowledgedSafetyChecks=" + String.valueOf(this.acknowledgedSafetyChecks) + ", id=" + this.id + ", status=" + String.valueOf((Object)this.status) + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class ComputerCallItem
        extends Item {
            @Required
            private Action action;
            @Required
            private String callId;
            @Required
            private List<SafetyCheck> pendingSafetyChecks;
            @Required
            private ItemStatus status;

            public ComputerCallItem(Action action, String callId, String id, List<SafetyCheck> pendingSafetyChecks, ItemStatus status) {
                this.action = action;
                this.callId = callId;
                this.id = id;
                this.pendingSafetyChecks = pendingSafetyChecks;
                this.status = status;
                this.type = ItemType.COMPUTER_CALL;
            }

            @Generated
            public static ComputerCallItemBuilder builder() {
                return new ComputerCallItemBuilder();
            }

            @Generated
            public ComputerCallItem() {
            }

            @Generated
            public Action getAction() {
                return this.action;
            }

            @Generated
            public String getCallId() {
                return this.callId;
            }

            @Generated
            public List<SafetyCheck> getPendingSafetyChecks() {
                return this.pendingSafetyChecks;
            }

            @Generated
            public ItemStatus getStatus() {
                return this.status;
            }

            @Generated
            public String toString() {
                return "Input.Item.ComputerCallItem(action=" + String.valueOf(this.getAction()) + ", callId=" + this.getCallId() + ", pendingSafetyChecks=" + String.valueOf(this.getPendingSafetyChecks()) + ", status=" + String.valueOf((Object)this.getStatus()) + ")";
            }

            @Generated
            public static class ComputerCallItemBuilder {
                @Generated
                private Action action;
                @Generated
                private String callId;
                @Generated
                private String id;
                @Generated
                private List<SafetyCheck> pendingSafetyChecks;
                @Generated
                private ItemStatus status;

                @Generated
                ComputerCallItemBuilder() {
                }

                @Generated
                public ComputerCallItemBuilder action(Action action) {
                    this.action = action;
                    return this;
                }

                @Generated
                public ComputerCallItemBuilder callId(String callId) {
                    this.callId = callId;
                    return this;
                }

                @Generated
                public ComputerCallItemBuilder id(String id) {
                    this.id = id;
                    return this;
                }

                @Generated
                public ComputerCallItemBuilder pendingSafetyChecks(List<SafetyCheck> pendingSafetyChecks) {
                    this.pendingSafetyChecks = pendingSafetyChecks;
                    return this;
                }

                @Generated
                public ComputerCallItemBuilder status(ItemStatus status) {
                    this.status = status;
                    return this;
                }

                @Generated
                public ComputerCallItem build() {
                    return new ComputerCallItem(this.action, this.callId, this.id, this.pendingSafetyChecks, this.status);
                }

                @Generated
                public String toString() {
                    return "Input.Item.ComputerCallItem.ComputerCallItemBuilder(action=" + String.valueOf(this.action) + ", callId=" + this.callId + ", id=" + this.id + ", pendingSafetyChecks=" + String.valueOf(this.pendingSafetyChecks) + ", status=" + String.valueOf((Object)this.status) + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class FileSearchCallItem
        extends Item {
            @Required
            private List<String> queries;
            @Required
            private SearchStatus status;
            private List<FileSearchResult> results;

            public FileSearchCallItem(String id, List<String> queries, SearchStatus status, List<FileSearchResult> results) {
                this.id = id;
                this.queries = queries;
                this.status = status;
                this.results = results;
                this.type = ItemType.FILE_SEARCH_CALL;
            }

            @Generated
            public static FileSearchCallItemBuilder builder() {
                return new FileSearchCallItemBuilder();
            }

            @Generated
            public FileSearchCallItem() {
            }

            @Generated
            public List<String> getQueries() {
                return this.queries;
            }

            @Generated
            public SearchStatus getStatus() {
                return this.status;
            }

            @Generated
            public List<FileSearchResult> getResults() {
                return this.results;
            }

            @Generated
            public String toString() {
                return "Input.Item.FileSearchCallItem(queries=" + String.valueOf(this.getQueries()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", results=" + String.valueOf(this.getResults()) + ")";
            }

            @Generated
            public static class FileSearchCallItemBuilder {
                @Generated
                private String id;
                @Generated
                private List<String> queries;
                @Generated
                private SearchStatus status;
                @Generated
                private List<FileSearchResult> results;

                @Generated
                FileSearchCallItemBuilder() {
                }

                @Generated
                public FileSearchCallItemBuilder id(String id) {
                    this.id = id;
                    return this;
                }

                @Generated
                public FileSearchCallItemBuilder queries(List<String> queries) {
                    this.queries = queries;
                    return this;
                }

                @Generated
                public FileSearchCallItemBuilder status(SearchStatus status) {
                    this.status = status;
                    return this;
                }

                @Generated
                public FileSearchCallItemBuilder results(List<FileSearchResult> results) {
                    this.results = results;
                    return this;
                }

                @Generated
                public FileSearchCallItem build() {
                    return new FileSearchCallItem(this.id, this.queries, this.status, this.results);
                }

                @Generated
                public String toString() {
                    return "Input.Item.FileSearchCallItem.FileSearchCallItemBuilder(id=" + this.id + ", queries=" + String.valueOf(this.queries) + ", status=" + String.valueOf((Object)this.status) + ", results=" + String.valueOf(this.results) + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class OutputMessageItem
        extends Item {
            @Required
            protected MessageRole role;
            protected ItemStatus status;
            @Required
            private List<OutputContent> content;

            public OutputMessageItem(List<OutputContent> content, String id, ItemStatus status) {
                this.content = content;
                this.id = id;
                this.status = status;
                this.role = MessageRole.ASSISTANT;
                this.type = ItemType.MESSAGE;
            }

            @Generated
            public static OutputMessageItemBuilder builder() {
                return new OutputMessageItemBuilder();
            }

            @Generated
            public OutputMessageItem() {
            }

            @Generated
            public MessageRole getRole() {
                return this.role;
            }

            @Generated
            public ItemStatus getStatus() {
                return this.status;
            }

            @Generated
            public List<OutputContent> getContent() {
                return this.content;
            }

            @Generated
            public String toString() {
                return "Input.Item.OutputMessageItem(role=" + String.valueOf((Object)this.getRole()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", content=" + String.valueOf(this.getContent()) + ")";
            }

            @Generated
            public static class OutputMessageItemBuilder {
                @Generated
                private List<OutputContent> content;
                @Generated
                private String id;
                @Generated
                private ItemStatus status;

                @Generated
                OutputMessageItemBuilder() {
                }

                @Generated
                public OutputMessageItemBuilder content(List<OutputContent> content) {
                    this.content = content;
                    return this;
                }

                @Generated
                public OutputMessageItemBuilder id(String id) {
                    this.id = id;
                    return this;
                }

                @Generated
                public OutputMessageItemBuilder status(ItemStatus status) {
                    this.status = status;
                    return this;
                }

                @Generated
                public OutputMessageItem build() {
                    return new OutputMessageItem(this.content, this.id, this.status);
                }

                @Generated
                public String toString() {
                    return "Input.Item.OutputMessageItem.OutputMessageItemBuilder(content=" + String.valueOf(this.content) + ", id=" + this.id + ", status=" + String.valueOf((Object)this.status) + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class InputMessageItem
        extends Item {
            @Required
            protected MessageRole role;
            protected ItemStatus status;
            @Required
            private List<Content> content;

            public InputMessageItem(List<Content> content, MessageRole role, ItemStatus status) {
                this.content = content;
                this.role = role;
                this.status = status;
                this.type = ItemType.MESSAGE;
            }

            @Generated
            public static InputMessageItemBuilder builder() {
                return new InputMessageItemBuilder();
            }

            @Generated
            public InputMessageItem() {
            }

            @Generated
            public MessageRole getRole() {
                return this.role;
            }

            @Generated
            public ItemStatus getStatus() {
                return this.status;
            }

            @Generated
            public List<Content> getContent() {
                return this.content;
            }

            @Generated
            public String toString() {
                return "Input.Item.InputMessageItem(role=" + String.valueOf((Object)this.getRole()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", content=" + String.valueOf(this.getContent()) + ")";
            }

            @Generated
            public static class InputMessageItemBuilder {
                @Generated
                private List<Content> content;
                @Generated
                private MessageRole role;
                @Generated
                private ItemStatus status;

                @Generated
                InputMessageItemBuilder() {
                }

                @Generated
                public InputMessageItemBuilder content(List<Content> content) {
                    this.content = content;
                    return this;
                }

                @Generated
                public InputMessageItemBuilder role(MessageRole role) {
                    this.role = role;
                    return this;
                }

                @Generated
                public InputMessageItemBuilder status(ItemStatus status) {
                    this.status = status;
                    return this;
                }

                @Generated
                public InputMessageItem build() {
                    return new InputMessageItem(this.content, this.role, this.status);
                }

                @Generated
                public String toString() {
                    return "Input.Item.InputMessageItem.InputMessageItemBuilder(content=" + String.valueOf(this.content) + ", role=" + String.valueOf((Object)this.role) + ", status=" + String.valueOf((Object)this.status) + ")";
                }
            }
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextInputContent.class, name="input_text"), @JsonSubTypes.Type(value=ImageInputContent.class, name="input_image"), @JsonSubTypes.Type(value=FileInputContent.class, name="input_file")})
    public static abstract class Content {
        protected ContentType type;

        @Generated
        public ContentType getType() {
            return this.type;
        }

        @Generated
        public void setType(ContentType type) {
            this.type = type;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class FileInputContent
        extends Content {
            private String fileData;
            private String fileId;
            private String filename;

            public FileInputContent(String fileData, String fileId, String filename) {
                this.fileData = fileData;
                this.fileId = fileId;
                this.filename = filename;
                this.type = ContentType.INPUT_FILE;
            }

            @Generated
            public static FileInputContentBuilder builder() {
                return new FileInputContentBuilder();
            }

            @Generated
            public FileInputContent() {
            }

            @Generated
            public String getFileData() {
                return this.fileData;
            }

            @Generated
            public String getFileId() {
                return this.fileId;
            }

            @Generated
            public String getFilename() {
                return this.filename;
            }

            @Generated
            public String toString() {
                return "Input.Content.FileInputContent(fileData=" + this.getFileData() + ", fileId=" + this.getFileId() + ", filename=" + this.getFilename() + ")";
            }

            @Generated
            public static class FileInputContentBuilder {
                @Generated
                private String fileData;
                @Generated
                private String fileId;
                @Generated
                private String filename;

                @Generated
                FileInputContentBuilder() {
                }

                @Generated
                public FileInputContentBuilder fileData(String fileData) {
                    this.fileData = fileData;
                    return this;
                }

                @Generated
                public FileInputContentBuilder fileId(String fileId) {
                    this.fileId = fileId;
                    return this;
                }

                @Generated
                public FileInputContentBuilder filename(String filename) {
                    this.filename = filename;
                    return this;
                }

                @Generated
                public FileInputContent build() {
                    return new FileInputContent(this.fileData, this.fileId, this.filename);
                }

                @Generated
                public String toString() {
                    return "Input.Content.FileInputContent.FileInputContentBuilder(fileData=" + this.fileData + ", fileId=" + this.fileId + ", filename=" + this.filename + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class ImageInputContent
        extends Content {
            @Required
            private ImageDetail detail;
            private String fileId;
            @Required
            private String imageUrl;

            public ImageInputContent(ImageDetail detail, String fileId, String imageUrl) {
                this.detail = detail;
                this.fileId = fileId;
                this.imageUrl = imageUrl;
                this.type = ContentType.INPUT_IMAGE;
            }

            public static ImageInputContent of(String imageUrl) {
                return ImageInputContent.builder().imageUrl(imageUrl).detail(ImageDetail.AUTO).build();
            }

            @Generated
            public static ImageInputContentBuilder builder() {
                return new ImageInputContentBuilder();
            }

            @Generated
            public ImageInputContent() {
            }

            @Generated
            public ImageDetail getDetail() {
                return this.detail;
            }

            @Generated
            public String getFileId() {
                return this.fileId;
            }

            @Generated
            public String getImageUrl() {
                return this.imageUrl;
            }

            @Generated
            public String toString() {
                return "Input.Content.ImageInputContent(detail=" + String.valueOf((Object)this.getDetail()) + ", fileId=" + this.getFileId() + ", imageUrl=" + this.getImageUrl() + ")";
            }

            @Generated
            public static class ImageInputContentBuilder {
                @Generated
                private ImageDetail detail;
                @Generated
                private String fileId;
                @Generated
                private String imageUrl;

                @Generated
                ImageInputContentBuilder() {
                }

                @Generated
                public ImageInputContentBuilder detail(ImageDetail detail) {
                    this.detail = detail;
                    return this;
                }

                @Generated
                public ImageInputContentBuilder fileId(String fileId) {
                    this.fileId = fileId;
                    return this;
                }

                @Generated
                public ImageInputContentBuilder imageUrl(String imageUrl) {
                    this.imageUrl = imageUrl;
                    return this;
                }

                @Generated
                public ImageInputContent build() {
                    return new ImageInputContent(this.detail, this.fileId, this.imageUrl);
                }

                @Generated
                public String toString() {
                    return "Input.Content.ImageInputContent.ImageInputContentBuilder(detail=" + String.valueOf((Object)this.detail) + ", fileId=" + this.fileId + ", imageUrl=" + this.imageUrl + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class TextInputContent
        extends Content {
            @Required
            private String text;

            private TextInputContent(String text) {
                this.text = text;
                this.type = ContentType.INPUT_TEXT;
            }

            public static TextInputContent of(String text) {
                return new TextInputContent(text);
            }

            @Generated
            public TextInputContent() {
            }

            @Generated
            public String getText() {
                return this.text;
            }

            @Generated
            public String toString() {
                return "Input.Content.TextInputContent(text=" + this.getText() + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ItemReference
    extends Input {
        @Required
        private String id;
        private InputType type;

        private ItemReference(String id) {
            this.id = id;
            this.type = InputType.ITEM_REFERENCE;
        }

        public static ItemReference of(String id) {
            return new ItemReference(id);
        }

        @Generated
        public ItemReference() {
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public InputType getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "Input.ItemReference(id=" + this.getId() + ", type=" + String.valueOf((Object)this.getType()) + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class InputMessage
    extends Input {
        @Required
        @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=Content.class, firstGroup=true)})
        private Object content;
        @Required
        private MessageRole role;
        private InputType type;

        private InputMessage(Object content, MessageRole role) {
            this.content = content;
            this.role = role;
            this.type = InputType.MESSAGE;
        }

        public static InputMessage of(Object content, MessageRole role) {
            return new InputMessage(content, role);
        }

        @Generated
        public InputMessage() {
        }

        @Generated
        public Object getContent() {
            return this.content;
        }

        @Generated
        public MessageRole getRole() {
            return this.role;
        }

        @Generated
        public InputType getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "Input.InputMessage(content=" + String.valueOf(this.getContent()) + ", role=" + String.valueOf((Object)this.getRole()) + ", type=" + String.valueOf((Object)this.getType()) + ")";
        }
    }
}

