/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.completion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.StreamOptions;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.Map;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class CompletionRequest {
    @Required
    private String model;
    @Required
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=String.class, firstGroup=true), @ObjectType(baseClass=Integer.class, firstGroup=true), @ObjectType(baseClass=Integer.class, firstGroup=true, secondGroup=true)})
    private Object prompt;
    @Range(min=0.0, max=20.0)
    private Integer bestOf;
    private Boolean echo;
    @Range(min=-2.0, max=2.0)
    private Double frequencyPenalty;
    private Map<String, Integer> logitBias;
    @Range(min=0.0, max=5.0)
    private Integer logprobs;
    private Integer maxTokens;
    @Range(min=1.0, max=128.0)
    private Integer n;
    @Range(min=-2.0, max=2.0)
    private Double presencePenalty;
    private Integer seed;
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=String.class, firstGroup=true, maxSize=4)})
    private Object stop;
    private Boolean stream;
    private StreamOptions streamOptions;
    private String suffix;
    @Range(min=0.0, max=2.0)
    private Double temperature;
    @Range(min=0.0, max=1.0)
    private Double topP;
    private String user;

    @Generated
    CompletionRequest(String model, Object prompt, Integer bestOf, Boolean echo, Double frequencyPenalty, Map<String, Integer> logitBias, Integer logprobs, Integer maxTokens, Integer n, Double presencePenalty, Integer seed, Object stop, Boolean stream, StreamOptions streamOptions, String suffix, Double temperature, Double topP, String user) {
        this.model = model;
        this.prompt = prompt;
        this.bestOf = bestOf;
        this.echo = echo;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.logprobs = logprobs;
        this.maxTokens = maxTokens;
        this.n = n;
        this.presencePenalty = presencePenalty;
        this.seed = seed;
        this.stop = stop;
        this.stream = stream;
        this.streamOptions = streamOptions;
        this.suffix = suffix;
        this.temperature = temperature;
        this.topP = topP;
        this.user = user;
    }

    @Generated
    public static CompletionRequestBuilder builder() {
        return new CompletionRequestBuilder();
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public Object getPrompt() {
        return this.prompt;
    }

    @Generated
    public Integer getBestOf() {
        return this.bestOf;
    }

    @Generated
    public Boolean getEcho() {
        return this.echo;
    }

    @Generated
    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @Generated
    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    @Generated
    public Integer getLogprobs() {
        return this.logprobs;
    }

    @Generated
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    @Generated
    public Integer getN() {
        return this.n;
    }

    @Generated
    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    @Generated
    public Integer getSeed() {
        return this.seed;
    }

    @Generated
    public Object getStop() {
        return this.stop;
    }

    @Generated
    public Boolean getStream() {
        return this.stream;
    }

    @Generated
    public StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    @Generated
    public String getSuffix() {
        return this.suffix;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Double getTopP() {
        return this.topP;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public CompletionRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new CompletionRequest(this.model, this.prompt, this.bestOf, this.echo, this.frequencyPenalty, this.logitBias, this.logprobs, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, stream, this.streamOptions, this.suffix, this.temperature, this.topP, this.user);
    }

    @Generated
    public CompletionRequest withStreamOptions(StreamOptions streamOptions) {
        return this.streamOptions == streamOptions ? this : new CompletionRequest(this.model, this.prompt, this.bestOf, this.echo, this.frequencyPenalty, this.logitBias, this.logprobs, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, streamOptions, this.suffix, this.temperature, this.topP, this.user);
    }

    @Generated
    public static class CompletionRequestBuilder {
        @Generated
        private String model;
        @Generated
        private Object prompt;
        @Generated
        private Integer bestOf;
        @Generated
        private Boolean echo;
        @Generated
        private Double frequencyPenalty;
        @Generated
        private Map<String, Integer> logitBias;
        @Generated
        private Integer logprobs;
        @Generated
        private Integer maxTokens;
        @Generated
        private Integer n;
        @Generated
        private Double presencePenalty;
        @Generated
        private Integer seed;
        @Generated
        private Object stop;
        @Generated
        private Boolean stream;
        @Generated
        private StreamOptions streamOptions;
        @Generated
        private String suffix;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private String user;

        @Generated
        CompletionRequestBuilder() {
        }

        @Generated
        public CompletionRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public CompletionRequestBuilder prompt(Object prompt) {
            this.prompt = prompt;
            return this;
        }

        @Generated
        public CompletionRequestBuilder bestOf(Integer bestOf) {
            this.bestOf = bestOf;
            return this;
        }

        @Generated
        public CompletionRequestBuilder echo(Boolean echo) {
            this.echo = echo;
            return this;
        }

        @Generated
        public CompletionRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Generated
        public CompletionRequestBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        @Generated
        public CompletionRequestBuilder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        @Generated
        public CompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @Generated
        public CompletionRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        @Generated
        public CompletionRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @Generated
        public CompletionRequestBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        @Generated
        public CompletionRequestBuilder stop(Object stop) {
            this.stop = stop;
            return this;
        }

        @Generated
        public CompletionRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public CompletionRequestBuilder streamOptions(StreamOptions streamOptions) {
            this.streamOptions = streamOptions;
            return this;
        }

        @Generated
        public CompletionRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @Generated
        public CompletionRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public CompletionRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public CompletionRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public CompletionRequest build() {
            return new CompletionRequest(this.model, this.prompt, this.bestOf, this.echo, this.frequencyPenalty, this.logitBias, this.logprobs, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.streamOptions, this.suffix, this.temperature, this.topP, this.user);
        }

        @Generated
        public String toString() {
            return "CompletionRequest.CompletionRequestBuilder(model=" + this.model + ", prompt=" + this.prompt + ", bestOf=" + this.bestOf + ", echo=" + this.echo + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", logprobs=" + this.logprobs + ", maxTokens=" + this.maxTokens + ", n=" + this.n + ", presencePenalty=" + this.presencePenalty + ", seed=" + this.seed + ", stop=" + this.stop + ", stream=" + this.stream + ", streamOptions=" + this.streamOptions + ", suffix=" + this.suffix + ", temperature=" + this.temperature + ", topP=" + this.topP + ", user=" + this.user + ")";
        }
    }
}

