/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.cleverclient.client.HttpClientAdapter;
import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.retry.RetryConfig;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.base.ClientConfig;
import io.github.sashirestela.openai.base.OpenAIConfigurator;
import io.github.sashirestela.openai.base.OpenAIProvider;
import io.github.sashirestela.openai.service.ChatCompletionServices;
import io.github.sashirestela.openai.service.EmbeddingServices;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;

public class SimpleOpenAIGeminiGoogle
extends OpenAIProvider
implements ChatCompletionServices,
EmbeddingServices {
    protected SimpleOpenAIGeminiGoogle(@NonNull String apiKey, String baseUrl, HttpClientAdapter clientAdapter, RetryConfig retryConfig, ObjectMapper objectMapper) {
        super(((GeminiGoogleConfigurator.GeminiGoogleConfiguratorBuilder)((GeminiGoogleConfigurator.GeminiGoogleConfiguratorBuilder)((GeminiGoogleConfigurator.GeminiGoogleConfiguratorBuilder)((GeminiGoogleConfigurator.GeminiGoogleConfiguratorBuilder)((GeminiGoogleConfigurator.GeminiGoogleConfiguratorBuilder)GeminiGoogleConfigurator.builder().apiKey(apiKey)).baseUrl(baseUrl)).clientAdapter(clientAdapter)).retryConfig(retryConfig)).objectMapper(objectMapper)).build());
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
    }

    @Override
    public OpenAI.ChatCompletions chatCompletions() {
        return this.getOrCreateService(OpenAI.ChatCompletions.class);
    }

    @Override
    public OpenAI.Embeddings embeddings() {
        return this.getOrCreateService(OpenAI.Embeddings.class);
    }

    @Generated
    public static SimpleOpenAIGeminiGoogleBuilder builder() {
        return new SimpleOpenAIGeminiGoogleBuilder();
    }

    @Generated
    public static class SimpleOpenAIGeminiGoogleBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String baseUrl;
        @Generated
        private HttpClientAdapter clientAdapter;
        @Generated
        private RetryConfig retryConfig;
        @Generated
        private ObjectMapper objectMapper;

        @Generated
        SimpleOpenAIGeminiGoogleBuilder() {
        }

        @Generated
        public SimpleOpenAIGeminiGoogleBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public SimpleOpenAIGeminiGoogleBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public SimpleOpenAIGeminiGoogleBuilder clientAdapter(HttpClientAdapter clientAdapter) {
            this.clientAdapter = clientAdapter;
            return this;
        }

        @Generated
        public SimpleOpenAIGeminiGoogleBuilder retryConfig(RetryConfig retryConfig) {
            this.retryConfig = retryConfig;
            return this;
        }

        @Generated
        public SimpleOpenAIGeminiGoogleBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public SimpleOpenAIGeminiGoogle build() {
            return new SimpleOpenAIGeminiGoogle(this.apiKey, this.baseUrl, this.clientAdapter, this.retryConfig, this.objectMapper);
        }

        @Generated
        public String toString() {
            return "SimpleOpenAIGeminiGoogle.SimpleOpenAIGeminiGoogleBuilder(apiKey=" + this.apiKey + ", baseUrl=" + this.baseUrl + ", clientAdapter=" + this.clientAdapter + ", retryConfig=" + this.retryConfig + ", objectMapper=" + this.objectMapper + ")";
        }
    }

    static class GeminiGoogleConfigurator
    extends OpenAIConfigurator {
        @Override
        public ClientConfig buildConfig() {
            return ClientConfig.builder().baseUrl(Optional.ofNullable(this.baseUrl).orElse("https://generativelanguage.googleapis.com/v1beta/openai")).headers(Map.of("Authorization", "Bearer " + this.apiKey)).clientAdapter(this.clientAdapter).retryConfig(this.retryConfig).requestInterceptor(this.makeRequestInterceptor()).objectMapper(this.objectMapper).build();
        }

        private UnaryOperator<HttpRequestData> makeRequestInterceptor() {
            String VERSION_REGEX = "/v\\d+(\\.\\d+)?/";
            return request -> {
                String newUrl = request.getUrl().replaceFirst("/v\\d+(\\.\\d+)?/", "/");
                request.setUrl(newUrl);
                return request;
            };
        }

        @Generated
        protected GeminiGoogleConfigurator(GeminiGoogleConfiguratorBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static GeminiGoogleConfiguratorBuilder<?, ?> builder() {
            return new GeminiGoogleConfiguratorBuilderImpl();
        }

        @Generated
        private static final class GeminiGoogleConfiguratorBuilderImpl
        extends GeminiGoogleConfiguratorBuilder<GeminiGoogleConfigurator, GeminiGoogleConfiguratorBuilderImpl> {
            @Generated
            private GeminiGoogleConfiguratorBuilderImpl() {
            }

            @Override
            @Generated
            protected GeminiGoogleConfiguratorBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public GeminiGoogleConfigurator build() {
                return new GeminiGoogleConfigurator(this);
            }
        }

        @Generated
        public static abstract class GeminiGoogleConfiguratorBuilder<C extends GeminiGoogleConfigurator, B extends GeminiGoogleConfiguratorBuilder<C, B>>
        extends OpenAIConfigurator.OpenAIConfiguratorBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "SimpleOpenAIGeminiGoogle.GeminiGoogleConfigurator.GeminiGoogleConfiguratorBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

