/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.annotation.Body;
import io.github.sashirestela.cleverclient.annotation.DELETE;
import io.github.sashirestela.cleverclient.annotation.GET;
import io.github.sashirestela.cleverclient.annotation.Multipart;
import io.github.sashirestela.cleverclient.annotation.POST;
import io.github.sashirestela.cleverclient.annotation.Path;
import io.github.sashirestela.cleverclient.annotation.Query;
import io.github.sashirestela.cleverclient.annotation.Resource;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import io.github.sashirestela.openai.common.DeletedObject;
import io.github.sashirestela.openai.common.Generic;
import io.github.sashirestela.openai.common.Page;
import io.github.sashirestela.openai.common.StreamOptions;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.domain.audio.AudioResponseFormat;
import io.github.sashirestela.openai.domain.audio.SpeechRequest;
import io.github.sashirestela.openai.domain.audio.Transcription;
import io.github.sashirestela.openai.domain.audio.TranscriptionRequest;
import io.github.sashirestela.openai.domain.audio.TranslationRequest;
import io.github.sashirestela.openai.domain.batch.Batch;
import io.github.sashirestela.openai.domain.batch.BatchRequest;
import io.github.sashirestela.openai.domain.chat.Chat;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.completion.Completion;
import io.github.sashirestela.openai.domain.completion.CompletionRequest;
import io.github.sashirestela.openai.domain.embedding.Embedding;
import io.github.sashirestela.openai.domain.embedding.EmbeddingBase64;
import io.github.sashirestela.openai.domain.embedding.EmbeddingFloat;
import io.github.sashirestela.openai.domain.embedding.EmbeddingRequest;
import io.github.sashirestela.openai.domain.file.FileRequest;
import io.github.sashirestela.openai.domain.file.FileResponse;
import io.github.sashirestela.openai.domain.finetuning.FineTuning;
import io.github.sashirestela.openai.domain.finetuning.FineTuningCheckpoint;
import io.github.sashirestela.openai.domain.finetuning.FineTuningEvent;
import io.github.sashirestela.openai.domain.finetuning.FineTuningRequest;
import io.github.sashirestela.openai.domain.image.Image;
import io.github.sashirestela.openai.domain.image.ImageEditsRequest;
import io.github.sashirestela.openai.domain.image.ImageRequest;
import io.github.sashirestela.openai.domain.image.ImageVariationsRequest;
import io.github.sashirestela.openai.domain.model.Model;
import io.github.sashirestela.openai.domain.moderation.Moderation;
import io.github.sashirestela.openai.domain.moderation.ModerationRequest;
import io.github.sashirestela.openai.domain.realtime.RealtimeSession;
import io.github.sashirestela.openai.domain.realtime.RealtimeSessionToken;
import io.github.sashirestela.openai.domain.upload.Upload;
import io.github.sashirestela.openai.domain.upload.UploadCompleteRequest;
import io.github.sashirestela.openai.domain.upload.UploadPart;
import io.github.sashirestela.openai.domain.upload.UploadPartRequest;
import io.github.sashirestela.openai.domain.upload.UploadRequest;
import io.github.sashirestela.openai.exception.SimpleOpenAIException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface OpenAI {
    public static AudioResponseFormat getResponseFormat(AudioResponseFormat currValue, AudioResponseFormat orDefault, String methodName) {
        EnumSet<AudioResponseFormat> jsonEnumSet = EnumSet.of(AudioResponseFormat.JSON, AudioResponseFormat.VERBOSE_JSON);
        EnumSet<AudioResponseFormat> textEnumSet = EnumSet.complementOf(jsonEnumSet);
        boolean isText = textEnumSet.contains((Object)orDefault);
        AudioResponseFormat requestedFormat = currValue;
        if (requestedFormat != null) {
            if (isText != textEnumSet.contains((Object)requestedFormat)) {
                throw new SimpleOpenAIException("Unexpected responseFormat for the method {0}.", methodName, null);
            }
        } else {
            requestedFormat = orDefault;
        }
        return requestedFormat;
    }

    public static ChatRequest updateRequest(ChatRequest chatRequest, Boolean useStream) {
        ChatRequest updatedChatRequest = chatRequest.withStream(useStream);
        if (Boolean.TRUE.equals(useStream)) {
            updatedChatRequest = updatedChatRequest.withStreamOptions(StreamOptions.of(useStream));
        }
        if (!CommonUtil.isNullOrEmpty(chatRequest.getTools()) && chatRequest.getToolChoice() == null) {
            updatedChatRequest = updatedChatRequest.withToolChoice((Object)ToolChoiceOption.AUTO);
        }
        return updatedChatRequest;
    }

    @Resource(value="/v1/uploads")
    public static interface Uploads {
        @POST
        public CompletableFuture<Upload> create(@Body UploadRequest var1);

        @Multipart
        @POST(value="/{uploadId}/parts")
        public CompletableFuture<UploadPart> addPart(@Path(value="uploadId") String var1, @Body UploadPartRequest var2);

        @POST(value="/{uploadId}/complete")
        public CompletableFuture<Upload> complete(@Path(value="uploadId") String var1, @Body UploadCompleteRequest var2);

        @POST(value="/{uploadId}/cancel")
        public CompletableFuture<Upload> cancel(@Path(value="uploadId") String var1);
    }

    @Resource(value="/v1/realtime/sessions")
    public static interface SessionTokens {
        @POST
        public CompletableFuture<RealtimeSessionToken> create(@Body RealtimeSession var1);
    }

    @Resource(value="/v1/moderations")
    public static interface Moderations {
        @POST
        public CompletableFuture<Moderation> create(@Body ModerationRequest var1);
    }

    @Resource(value="/v1/models")
    public static interface Models {
        @GET
        public CompletableFuture<Generic<Model>> getListPrimitive();

        default public CompletableFuture<List<Model>> getList() {
            return this.getListPrimitive().thenApply(Generic::getData);
        }

        @GET(value="/{modelId}")
        public CompletableFuture<Model> getOne(@Path(value="modelId") String var1);

        @DELETE(value="/{modelId}")
        public CompletableFuture<DeletedObject> delete(@Path(value="modelId") String var1);
    }

    @Resource(value="/v1/images")
    public static interface Images {
        @POST(value="/generations")
        public CompletableFuture<Generic<Image>> createPrimitive(@Body ImageRequest var1);

        @Multipart
        @POST(value="/edits")
        public CompletableFuture<Generic<Image>> createEditsPrimitive(@Body ImageEditsRequest var1);

        @Multipart
        @POST(value="/variations")
        public CompletableFuture<Generic<Image>> createVariationsPrimitive(@Body ImageVariationsRequest var1);

        default public CompletableFuture<List<Image>> create(ImageRequest imageRequest) {
            return this.createPrimitive(imageRequest).thenApply(Generic::getData);
        }

        default public CompletableFuture<List<Image>> createEdits(ImageEditsRequest imageRequest) {
            return this.createEditsPrimitive(imageRequest).thenApply(Generic::getData);
        }

        default public CompletableFuture<List<Image>> createVariations(ImageVariationsRequest imageRequest) {
            return this.createVariationsPrimitive(imageRequest).thenApply(Generic::getData);
        }
    }

    @Resource(value="/v1/fine_tuning/jobs")
    public static interface FineTunings {
        @POST
        public CompletableFuture<FineTuning> create(@Body FineTuningRequest var1);

        @GET
        public CompletableFuture<Generic<FineTuning>> getListPrimitive(@Query(value="limit") Integer var1, @Query(value="after") String var2);

        default public CompletableFuture<List<FineTuning>> getList(Integer limit, String after) {
            return this.getListPrimitive(limit, after).thenApply(Generic::getData);
        }

        @GET(value="/{fineTuningId}")
        public CompletableFuture<FineTuning> getOne(@Path(value="fineTuningId") String var1);

        @GET(value="/{fineTuningId}/events")
        public CompletableFuture<Generic<FineTuningEvent>> getEventsPrimitive(@Path(value="fineTuningId") String var1, @Query(value="limit") Integer var2, @Query(value="after") String var3);

        default public CompletableFuture<List<FineTuningEvent>> getEvents(String fineTuningId, Integer limit, String after) {
            return this.getEventsPrimitive(fineTuningId, limit, after).thenApply(Generic::getData);
        }

        @GET(value="/{fineTuningId}/checkpoints")
        public CompletableFuture<Generic<FineTuningCheckpoint>> getCheckpointsPrimitive(@Path(value="fineTuningId") String var1, @Query(value="limit") Integer var2, @Query(value="after") String var3);

        default public CompletableFuture<List<FineTuningCheckpoint>> getCheckpoints(String fineTuningId, Integer limit, String after) {
            return this.getCheckpointsPrimitive(fineTuningId, limit, after).thenApply(Generic::getData);
        }

        @POST(value="/{fineTuningId}/cancel")
        public CompletableFuture<FineTuning> cancel(@Path(value="fineTuningId") String var1);
    }

    @Resource(value="/v1/files")
    public static interface Files {
        @Multipart
        @POST
        public CompletableFuture<FileResponse> create(@Body FileRequest var1);

        @GET
        public CompletableFuture<Generic<FileResponse>> getListPrimitive(@Query(value="purpose") FileRequest.PurposeType var1);

        default public CompletableFuture<List<FileResponse>> getList(FileRequest.PurposeType purpose) {
            return this.getListPrimitive(purpose).thenApply(Generic::getData);
        }

        @GET(value="/{fileId}")
        public CompletableFuture<FileResponse> getOne(@Path(value="fileId") String var1);

        @GET(value="/{fileId}/content")
        public CompletableFuture<String> getContent(@Path(value="fileId") String var1);

        @GET(value="/{fileId}/content")
        public CompletableFuture<InputStream> getContentInputStream(@Path(value="fileId") String var1);

        @DELETE(value="/{fileId}")
        public CompletableFuture<DeletedObject> delete(@Path(value="fileId") String var1);
    }

    @Resource(value="/v1/embeddings")
    public static interface Embeddings {
        @POST
        public CompletableFuture<Embedding<EmbeddingFloat>> createPrimitive(@Body EmbeddingRequest var1);

        @POST
        public CompletableFuture<Embedding<EmbeddingBase64>> createBase64Primitive(@Body EmbeddingRequest var1);

        default public CompletableFuture<Embedding<EmbeddingFloat>> create(@Body EmbeddingRequest embeddingRequest) {
            EmbeddingRequest request = embeddingRequest.withEncodingFormat(EmbeddingRequest.EncodingFormat.FLOAT);
            return this.createPrimitive(request);
        }

        default public CompletableFuture<Embedding<EmbeddingBase64>> createBase64(@Body EmbeddingRequest embeddingRequest) {
            EmbeddingRequest request = embeddingRequest.withEncodingFormat(EmbeddingRequest.EncodingFormat.BASE64);
            return this.createBase64Primitive(request);
        }
    }

    @Resource(value="/v1/completions")
    public static interface Completions {
        @POST
        public CompletableFuture<Completion> createPrimitive(@Body CompletionRequest var1);

        @POST
        public CompletableFuture<Stream<Completion>> createStreamPrimitive(@Body CompletionRequest var1);

        default public CompletableFuture<Completion> create(@Body CompletionRequest completionRequest) {
            CompletionRequest request = completionRequest.withStream(Boolean.FALSE);
            return this.createPrimitive(request);
        }

        default public CompletableFuture<Stream<Completion>> createStream(@Body CompletionRequest completionRequest) {
            CompletionRequest request = completionRequest.withStream(Boolean.TRUE).withStreamOptions(StreamOptions.of(Boolean.TRUE));
            return this.createStreamPrimitive(request);
        }
    }

    @Resource(value="/v1/chat/completions")
    public static interface ChatCompletions {
        @POST
        public CompletableFuture<Chat> createPrimitive(@Body ChatRequest var1);

        @POST
        public CompletableFuture<Stream<Chat>> createStreamPrimitive(@Body ChatRequest var1);

        default public CompletableFuture<Chat> create(@Body ChatRequest chatRequest) {
            ChatRequest request = OpenAI.updateRequest(chatRequest, Boolean.FALSE);
            return this.createPrimitive(request);
        }

        default public CompletableFuture<Stream<Chat>> createStream(@Body ChatRequest chatRequest) {
            ChatRequest request = OpenAI.updateRequest(chatRequest, Boolean.TRUE);
            return this.createStreamPrimitive(request);
        }
    }

    @Resource(value="/v1/batches")
    public static interface Batches {
        @POST
        public CompletableFuture<Batch> create(@Body BatchRequest var1);

        @GET(value="/{batchId}")
        public CompletableFuture<Batch> getOne(@Path(value="batchId") String var1);

        @POST(value="/{batchId}/cancel")
        public CompletableFuture<Batch> cancel(@Path(value="batchId") String var1);

        @GET
        public CompletableFuture<Page<Batch>> getList(@Query(value="after") String var1, @Query(value="limit") Integer var2);
    }

    @Resource(value="/v1/audio")
    public static interface Audios {
        @POST(value="/speech")
        public CompletableFuture<InputStream> speak(@Body SpeechRequest var1);

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<Transcription> transcribePrimitive(@Body TranscriptionRequest var1);

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<Transcription> translatePrimitive(@Body TranslationRequest var1);

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<String> transcribePlainPrimitive(@Body TranscriptionRequest var1);

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<String> translatePlainPrimitive(@Body TranslationRequest var1);

        default public CompletableFuture<Transcription> transcribe(TranscriptionRequest audioRequest) {
            AudioResponseFormat responseFormat = OpenAI.getResponseFormat(audioRequest.getResponseFormat(), AudioResponseFormat.JSON, "transcribe");
            TranscriptionRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.transcribePrimitive(request);
        }

        default public CompletableFuture<Transcription> translate(TranslationRequest audioRequest) {
            AudioResponseFormat responseFormat = OpenAI.getResponseFormat(audioRequest.getResponseFormat(), AudioResponseFormat.JSON, "translate");
            TranslationRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.translatePrimitive(request);
        }

        default public CompletableFuture<String> transcribePlain(TranscriptionRequest audioRequest) {
            AudioResponseFormat responseFormat = OpenAI.getResponseFormat(audioRequest.getResponseFormat(), AudioResponseFormat.TEXT, "transcribe");
            TranscriptionRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.transcribePlainPrimitive(request);
        }

        default public CompletableFuture<String> translatePlain(TranslationRequest audioRequest) {
            AudioResponseFormat responseFormat = OpenAI.getResponseFormat(audioRequest.getResponseFormat(), AudioResponseFormat.TEXT, "translate");
            TranslationRequest request = audioRequest.withResponseFormat(responseFormat);
            return this.translatePlainPrimitive(request);
        }
    }
}

