/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.cleverclient.client.HttpClientAdapter;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.base.ClientConfig;
import io.github.sashirestela.openai.base.OpenAIConfigurator;
import io.github.sashirestela.openai.base.OpenAIProvider;
import io.github.sashirestela.openai.service.ChatCompletionServices;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class SimpleOpenAIAnyscale
extends OpenAIProvider
implements ChatCompletionServices {
    public SimpleOpenAIAnyscale(@NonNull String apiKey, String baseUrl, HttpClient httpClient, HttpClientAdapter clientAdapter, ObjectMapper objectMapper) {
        super(((AnyscaleConfigurator.AnyscaleConfiguratorBuilder)((AnyscaleConfigurator.AnyscaleConfiguratorBuilder)((AnyscaleConfigurator.AnyscaleConfiguratorBuilder)((AnyscaleConfigurator.AnyscaleConfiguratorBuilder)((AnyscaleConfigurator.AnyscaleConfiguratorBuilder)AnyscaleConfigurator.builder().apiKey(apiKey)).baseUrl(baseUrl)).httpClient(httpClient)).clientAdapter(clientAdapter)).objectMapper(objectMapper)).build());
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
    }

    @Override
    public OpenAI.ChatCompletions chatCompletions() {
        return this.getOrCreateService(OpenAI.ChatCompletions.class);
    }

    @Generated
    public static SimpleOpenAIAnyscaleBuilder builder() {
        return new SimpleOpenAIAnyscaleBuilder();
    }

    @Generated
    public static class SimpleOpenAIAnyscaleBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String baseUrl;
        @Generated
        private HttpClient httpClient;
        @Generated
        private HttpClientAdapter clientAdapter;
        @Generated
        private ObjectMapper objectMapper;

        @Generated
        SimpleOpenAIAnyscaleBuilder() {
        }

        @Generated
        public SimpleOpenAIAnyscaleBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public SimpleOpenAIAnyscaleBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public SimpleOpenAIAnyscaleBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public SimpleOpenAIAnyscaleBuilder clientAdapter(HttpClientAdapter clientAdapter) {
            this.clientAdapter = clientAdapter;
            return this;
        }

        @Generated
        public SimpleOpenAIAnyscaleBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public SimpleOpenAIAnyscale build() {
            return new SimpleOpenAIAnyscale(this.apiKey, this.baseUrl, this.httpClient, this.clientAdapter, this.objectMapper);
        }

        @Generated
        public String toString() {
            return "SimpleOpenAIAnyscale.SimpleOpenAIAnyscaleBuilder(apiKey=" + this.apiKey + ", baseUrl=" + this.baseUrl + ", httpClient=" + this.httpClient + ", clientAdapter=" + this.clientAdapter + ", objectMapper=" + this.objectMapper + ")";
        }
    }

    static class AnyscaleConfigurator
    extends OpenAIConfigurator {
        @Override
        public ClientConfig buildConfig() {
            return ClientConfig.builder().baseUrl(Optional.ofNullable(this.baseUrl).orElse("https://api.endpoints.anyscale.com")).headers(Map.of("Authorization", "Bearer " + this.apiKey)).httpClient(this.httpClient).clientAdapter(this.clientAdapter).objectMapper(this.objectMapper).build();
        }

        @Generated
        protected AnyscaleConfigurator(AnyscaleConfiguratorBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static AnyscaleConfiguratorBuilder<?, ?> builder() {
            return new AnyscaleConfiguratorBuilderImpl();
        }

        @Generated
        private static final class AnyscaleConfiguratorBuilderImpl
        extends AnyscaleConfiguratorBuilder<AnyscaleConfigurator, AnyscaleConfiguratorBuilderImpl> {
            @Generated
            private AnyscaleConfiguratorBuilderImpl() {
            }

            @Override
            @Generated
            protected AnyscaleConfiguratorBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AnyscaleConfigurator build() {
                return new AnyscaleConfigurator(this);
            }
        }

        @Generated
        public static abstract class AnyscaleConfiguratorBuilder<C extends AnyscaleConfigurator, B extends AnyscaleConfiguratorBuilder<C, B>>
        extends OpenAIConfigurator.OpenAIConfiguratorBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "SimpleOpenAIAnyscale.AnyscaleConfigurator.AnyscaleConfiguratorBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

