/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.util.JsonUtil;
import io.github.sashirestela.openai.base.RealtimeConfig;
import io.github.sashirestela.openai.domain.realtime.BaseEvent;
import io.github.sashirestela.openai.support.Action;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIRealtime {
    private static final Logger logger = LoggerFactory.getLogger(OpenAIRealtime.class);
    private Map<Class<?>, Consumer<Object>> eventHandlers = new HashMap();
    private WebSocket.Builder webSocketWithHeaders;
    private String fullUrl;
    private Action openHandler;
    private BiConsumer<Integer, String> closeHandler;
    private Consumer<Throwable> errorHandler;
    private WebSocket webSocket;

    public OpenAIRealtime(HttpClient httpClient, RealtimeConfig realtimeConfig) {
        this.webSocketWithHeaders = this.buildWebSocketWithHeaders(httpClient, realtimeConfig);
        this.fullUrl = this.buildFullUrl(realtimeConfig);
    }

    private WebSocket.Builder buildWebSocketWithHeaders(HttpClient httpClient, RealtimeConfig realtimeConfig) {
        WebSocket.Builder webSocketBuilder = httpClient.newWebSocketBuilder();
        for (Map.Entry<String, String> entry : realtimeConfig.getHeaders().entrySet()) {
            webSocketBuilder = webSocketBuilder.header(entry.getKey(), entry.getValue());
        }
        return webSocketBuilder;
    }

    private String buildFullUrl(RealtimeConfig realtimeConfig) {
        StringBuilder url = new StringBuilder(realtimeConfig.getEndpointUrl() + "?");
        for (Map.Entry<String, String> entry : realtimeConfig.getQueryParams().entrySet()) {
            url.append(entry.getKey() + "=" + entry.getValue());
        }
        return url.toString();
    }

    public <T> void onEvent(Class<T> eventClass, Consumer<T> handler) {
        Consumer<T> genericHandler = handler;
        this.eventHandlers.put(eventClass, genericHandler);
    }

    public void onOpen(Action openHandler) {
        this.openHandler = openHandler;
    }

    public void onClose(BiConsumer<Integer, String> closeHandler) {
        this.closeHandler = closeHandler;
    }

    public void onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public CompletableFuture<WebSocket> connect() {
        logger.debug("Starting connection");
        return this.webSocketWithHeaders.buildAsync(URI.create(this.fullUrl), new OpenAIRealtimeListener()).thenApply(ws -> {
            this.webSocket = ws;
            return ws;
        });
    }

    public void disconnect() {
        if (this.webSocket != null) {
            logger.debug("Closing connection");
            this.webSocket.sendClose(1000, "Closing connection");
        }
    }

    public CompletableFuture<WebSocket> send(BaseEvent clientEvent) {
        String jsonData = JsonUtil.objectToJson((Object)clientEvent);
        logger.debug("Request Event : {}", (Object)jsonData);
        return this.webSocket.sendText(jsonData, true);
    }

    @Generated
    public static OpenAIRealtimeBuilder builder() {
        return new OpenAIRealtimeBuilder();
    }

    @Generated
    public static class OpenAIRealtimeBuilder {
        @Generated
        private HttpClient httpClient;
        @Generated
        private RealtimeConfig realtimeConfig;

        @Generated
        OpenAIRealtimeBuilder() {
        }

        @Generated
        public OpenAIRealtimeBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public OpenAIRealtimeBuilder realtimeConfig(RealtimeConfig realtimeConfig) {
            this.realtimeConfig = realtimeConfig;
            return this;
        }

        @Generated
        public OpenAIRealtime build() {
            return new OpenAIRealtime(this.httpClient, this.realtimeConfig);
        }

        @Generated
        public String toString() {
            return "OpenAIRealtime.OpenAIRealtimeBuilder(httpClient=" + this.httpClient + ", realtimeConfig=" + this.realtimeConfig + ")";
        }
    }

    private class OpenAIRealtimeListener
    implements WebSocket.Listener {
        private StringBuilder dataBuffer = new StringBuilder();

        private OpenAIRealtimeListener() {
        }

        @Override
        public void onOpen(WebSocket webSocket) {
            logger.debug("Connection started");
            if (OpenAIRealtime.this.openHandler != null) {
                OpenAIRealtime.this.openHandler.execute();
            }
            webSocket.request(1L);
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            this.dataBuffer.append(data);
            if (last) {
                String jsonData = this.dataBuffer.toString();
                logger.debug("Response Event : {}", (Object)jsonData);
                this.dataBuffer = new StringBuilder();
                BaseEvent event = (BaseEvent)JsonUtil.jsonToObject((String)jsonData, BaseEvent.class);
                Consumer<Object> handler = OpenAIRealtime.this.eventHandlers.get(event.getClass());
                if (handler != null) {
                    handler.accept(event);
                }
            }
            webSocket.request(1L);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            logger.debug("Connection closed");
            if (OpenAIRealtime.this.closeHandler != null) {
                OpenAIRealtime.this.closeHandler.accept(statusCode, reason);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            Object errorMessage = error.getMessage();
            if (error.getCause() != null) {
                errorMessage = (String)errorMessage + "\n" + error.getCause().getMessage();
            }
            logger.debug("Connection error : {}", errorMessage);
            if (OpenAIRealtime.this.errorHandler != null) {
                OpenAIRealtime.this.errorHandler.accept(error);
            }
        }
    }
}

