/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.exception;

import io.github.sashirestela.cleverclient.ExceptionConverter;
import io.github.sashirestela.cleverclient.ResponseInfo;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import io.github.sashirestela.openai.exception.OpenAIException;
import io.github.sashirestela.openai.exception.OpenAIResponseInfo;

public class OpenAIExceptionConverter
extends ExceptionConverter {
    public static void rethrow(Throwable e) {
        throw new OpenAIExceptionConverter().convert(e);
    }

    public RuntimeException convertHttpException(ResponseInfo responseInfo) {
        OpenAIResponseInfo openAIResponseInfo = this.mapResponseInfo(responseInfo);
        int status = openAIResponseInfo.getStatus();
        switch (status) {
            case 400: {
                return new OpenAIException.BadRequestException(openAIResponseInfo);
            }
            case 401: {
                return new OpenAIException.AuthenticationException(openAIResponseInfo);
            }
            case 403: {
                return new OpenAIException.PermissionDeniedException(openAIResponseInfo);
            }
            case 404: {
                return new OpenAIException.NotFoundException(openAIResponseInfo);
            }
            case 422: {
                return new OpenAIException.UnprocessableEntityException(openAIResponseInfo);
            }
            case 429: {
                return new OpenAIException.RateLimitException(openAIResponseInfo);
            }
        }
        if (status >= 500) {
            return new OpenAIException.InternalServerException(openAIResponseInfo);
        }
        return new OpenAIException.UnexpectedStatusCodeException(openAIResponseInfo);
    }

    private OpenAIResponseInfo mapResponseInfo(ResponseInfo responseInfo) {
        ResponseInfo.RequestInfo requestInfo = responseInfo.getRequest();
        return OpenAIResponseInfo.builder().status(responseInfo.getStatusCode()).errorResponse((OpenAIResponseInfo.OpenAIErrorResponse)JsonUtil.jsonToObject((String)responseInfo.getData(), OpenAIResponseInfo.OpenAIErrorResponse.class)).httpMethod(requestInfo.getHttpMethod()).url(requestInfo.getUrl()).responseHeaders(responseInfo.getHeaders()).requestHeaders(requestInfo.getHeaders()).build();
    }
}

