/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.realtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.realtime.Item;
import io.github.sashirestela.openai.domain.realtime.RealtimeSession;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class RealtimeResponse {
    private List<ChatRequest.Modality> modalities;
    private String instructions;
    private RealtimeSession.VoiceRealtime voice;
    private RealtimeSession.AudioFormatRealtime outputAudioFormat;
    private List<RealtimeSession.ToolRealtime> tools;
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ToolChoiceOption.class)})
    private Object toolChoice;
    @Range(min=0.6, max=1.2)
    private Double temperature;
    @Range(min=1.0, max=4096.0)
    @ObjectType.List(value={@ObjectType(baseClass=Integer.class), @ObjectType(baseClass=String.class)})
    private Object maxResponseOutputTokens;
    private ConversationType conversation;
    @Size(max=16)
    private Map<String, String> metadata;
    private List<Item> input;

    @Generated
    public static RealtimeResponseBuilder builder() {
        return new RealtimeResponseBuilder();
    }

    @Generated
    public List<ChatRequest.Modality> getModalities() {
        return this.modalities;
    }

    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    @Generated
    public RealtimeSession.VoiceRealtime getVoice() {
        return this.voice;
    }

    @Generated
    public RealtimeSession.AudioFormatRealtime getOutputAudioFormat() {
        return this.outputAudioFormat;
    }

    @Generated
    public List<RealtimeSession.ToolRealtime> getTools() {
        return this.tools;
    }

    @Generated
    public Object getToolChoice() {
        return this.toolChoice;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Object getMaxResponseOutputTokens() {
        return this.maxResponseOutputTokens;
    }

    @Generated
    public ConversationType getConversation() {
        return this.conversation;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public List<Item> getInput() {
        return this.input;
    }

    @Generated
    public String toString() {
        return "RealtimeResponse(modalities=" + this.getModalities() + ", instructions=" + this.getInstructions() + ", voice=" + this.getVoice() + ", outputAudioFormat=" + this.getOutputAudioFormat() + ", tools=" + this.getTools() + ", toolChoice=" + this.getToolChoice() + ", temperature=" + this.getTemperature() + ", maxResponseOutputTokens=" + this.getMaxResponseOutputTokens() + ", conversation=" + this.getConversation() + ", metadata=" + this.getMetadata() + ", input=" + this.getInput() + ")";
    }

    @Generated
    public RealtimeResponse() {
    }

    @Generated
    public RealtimeResponse(List<ChatRequest.Modality> modalities, String instructions, RealtimeSession.VoiceRealtime voice, RealtimeSession.AudioFormatRealtime outputAudioFormat, List<RealtimeSession.ToolRealtime> tools, Object toolChoice, Double temperature, Object maxResponseOutputTokens, ConversationType conversation, Map<String, String> metadata, List<Item> input) {
        this.modalities = modalities;
        this.instructions = instructions;
        this.voice = voice;
        this.outputAudioFormat = outputAudioFormat;
        this.tools = tools;
        this.toolChoice = toolChoice;
        this.temperature = temperature;
        this.maxResponseOutputTokens = maxResponseOutputTokens;
        this.conversation = conversation;
        this.metadata = metadata;
        this.input = input;
    }

    @Generated
    public static class RealtimeResponseBuilder {
        @Generated
        private ArrayList<ChatRequest.Modality> modalities;
        @Generated
        private String instructions;
        @Generated
        private RealtimeSession.VoiceRealtime voice;
        @Generated
        private RealtimeSession.AudioFormatRealtime outputAudioFormat;
        @Generated
        private ArrayList<RealtimeSession.ToolRealtime> tools;
        @Generated
        private Object toolChoice;
        @Generated
        private Double temperature;
        @Generated
        private Object maxResponseOutputTokens;
        @Generated
        private ConversationType conversation;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private ArrayList<Item> input;

        @Generated
        RealtimeResponseBuilder() {
        }

        @Generated
        public RealtimeResponseBuilder modality(ChatRequest.Modality modality) {
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.add(modality);
            return this;
        }

        @Generated
        public RealtimeResponseBuilder modalities(Collection<? extends ChatRequest.Modality> modalities) {
            if (modalities == null) {
                throw new NullPointerException("modalities cannot be null");
            }
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.addAll(modalities);
            return this;
        }

        @Generated
        public RealtimeResponseBuilder clearModalities() {
            if (this.modalities != null) {
                this.modalities.clear();
            }
            return this;
        }

        @Generated
        public RealtimeResponseBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        @Generated
        public RealtimeResponseBuilder voice(RealtimeSession.VoiceRealtime voice) {
            this.voice = voice;
            return this;
        }

        @Generated
        public RealtimeResponseBuilder outputAudioFormat(RealtimeSession.AudioFormatRealtime outputAudioFormat) {
            this.outputAudioFormat = outputAudioFormat;
            return this;
        }

        @Generated
        public RealtimeResponseBuilder tool(RealtimeSession.ToolRealtime tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        @Generated
        public RealtimeResponseBuilder tools(Collection<? extends RealtimeSession.ToolRealtime> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        @Generated
        public RealtimeResponseBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        @Generated
        public RealtimeResponseBuilder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @Generated
        public RealtimeResponseBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public RealtimeResponseBuilder maxResponseOutputTokens(Object maxResponseOutputTokens) {
            this.maxResponseOutputTokens = maxResponseOutputTokens;
            return this;
        }

        @Generated
        public RealtimeResponseBuilder conversation(ConversationType conversation) {
            this.conversation = conversation;
            return this;
        }

        @Generated
        public RealtimeResponseBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public RealtimeResponseBuilder inputItem(Item inputItem) {
            if (this.input == null) {
                this.input = new ArrayList();
            }
            this.input.add(inputItem);
            return this;
        }

        @Generated
        public RealtimeResponseBuilder input(Collection<? extends Item> input) {
            if (input == null) {
                throw new NullPointerException("input cannot be null");
            }
            if (this.input == null) {
                this.input = new ArrayList();
            }
            this.input.addAll(input);
            return this;
        }

        @Generated
        public RealtimeResponseBuilder clearInput() {
            if (this.input != null) {
                this.input.clear();
            }
            return this;
        }

        @Generated
        public RealtimeResponse build() {
            List<Item> input;
            List<RealtimeSession.ToolRealtime> tools;
            List<ChatRequest.Modality> modalities;
            switch (this.modalities == null ? 0 : this.modalities.size()) {
                case 0: {
                    modalities = Collections.emptyList();
                    break;
                }
                case 1: {
                    modalities = Collections.singletonList(this.modalities.get(0));
                    break;
                }
                default: {
                    modalities = Collections.unmodifiableList(new ArrayList<ChatRequest.Modality>(this.modalities));
                }
            }
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<RealtimeSession.ToolRealtime>(this.tools));
                }
            }
            switch (this.input == null ? 0 : this.input.size()) {
                case 0: {
                    input = Collections.emptyList();
                    break;
                }
                case 1: {
                    input = Collections.singletonList(this.input.get(0));
                    break;
                }
                default: {
                    input = Collections.unmodifiableList(new ArrayList<Item>(this.input));
                }
            }
            return new RealtimeResponse(modalities, this.instructions, this.voice, this.outputAudioFormat, tools, this.toolChoice, this.temperature, this.maxResponseOutputTokens, this.conversation, this.metadata, input);
        }

        @Generated
        public String toString() {
            return "RealtimeResponse.RealtimeResponseBuilder(modalities=" + this.modalities + ", instructions=" + this.instructions + ", voice=" + this.voice + ", outputAudioFormat=" + this.outputAudioFormat + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ", temperature=" + this.temperature + ", maxResponseOutputTokens=" + this.maxResponseOutputTokens + ", conversation=" + this.conversation + ", metadata=" + this.metadata + ", input=" + this.input + ")";
        }
    }

    public static enum ConversationType {
        AUTO,
        NONE;

    }
}

