/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.openai.BaseSimpleOpenAI;
import io.github.sashirestela.openai.BaseSimpleOpenAIArgs;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.OpenAIBeta2;
import io.github.sashirestela.openai.OpenAIRealtime;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.net.http.HttpClient;
import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class SimpleOpenAI
extends BaseSimpleOpenAI {
    public SimpleOpenAI(@NonNull String apiKey, String organizationId, String projectId, String baseUrl, HttpClient httpClient, ObjectMapper objectMapper, RealtimeConfig realtimeConfig) {
        super(SimpleOpenAI.prepareBaseSimpleOpenAIArgs(apiKey, organizationId, projectId, baseUrl, httpClient, objectMapper, realtimeConfig));
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
    }

    public static BaseSimpleOpenAIArgs prepareBaseSimpleOpenAIArgs(String apiKey, String organizationId, String projectId, String baseUrl, HttpClient httpClient, ObjectMapper objectMapper, RealtimeConfig realtimeConfig) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + apiKey);
        if (organizationId != null) {
            headers.put("OpenAI-Organization", organizationId);
        }
        if (projectId != null) {
            headers.put("OpenAI-Project", projectId);
        }
        OpenAIRealtime.BaseRealtimeConfig baseRealtimeConfig = null;
        if (realtimeConfig != null) {
            HashMap<String, String> realtimeHeaders = new HashMap<String, String>();
            realtimeHeaders.put("Authorization", "Bearer " + apiKey);
            realtimeHeaders.put("OpenAI-Beta", "realtime=v1");
            HashMap<String, String> realtimeQueryParams = new HashMap<String, String>();
            realtimeQueryParams.put("model", realtimeConfig.getModel());
            baseRealtimeConfig = (OpenAIRealtime.BaseRealtimeConfig)((OpenAIRealtime.BaseRealtimeConfig.BaseRealtimeConfigBuilder)((OpenAIRealtime.BaseRealtimeConfig.BaseRealtimeConfigBuilder)((OpenAIRealtime.BaseRealtimeConfig.BaseRealtimeConfigBuilder)OpenAIRealtime.BaseRealtimeConfig.builder().endpointUrl(Optional.ofNullable(realtimeConfig.getEndpointUrl()).orElse("wss://api.openai.com/v1/realtime"))).headers(realtimeHeaders)).queryParams(realtimeQueryParams)).build();
        }
        return BaseSimpleOpenAIArgs.builder().baseUrl(Optional.ofNullable(baseUrl).orElse("https://api.openai.com")).headers(headers).httpClient(httpClient).objectMapper(objectMapper).baseRealtimeConfig(baseRealtimeConfig).build();
    }

    @Override
    public OpenAI.Audios audios() {
        if (this.audioService == null) {
            this.audioService = (OpenAI.Audios)this.cleverClient.create(OpenAI.Audios.class);
        }
        return this.audioService;
    }

    @Override
    public OpenAI.Batches batches() {
        if (this.batchService == null) {
            this.batchService = (OpenAI.Batches)this.cleverClient.create(OpenAI.Batches.class);
        }
        return this.batchService;
    }

    @Override
    public OpenAI.Completions completions() {
        if (this.completionService == null) {
            this.completionService = (OpenAI.Completions)this.cleverClient.create(OpenAI.Completions.class);
        }
        return this.completionService;
    }

    @Override
    public OpenAI.Embeddings embeddings() {
        if (this.embeddingService == null) {
            this.embeddingService = (OpenAI.Embeddings)this.cleverClient.create(OpenAI.Embeddings.class);
        }
        return this.embeddingService;
    }

    @Override
    public OpenAI.FineTunings fineTunings() {
        if (this.fineTuningService == null) {
            this.fineTuningService = (OpenAI.FineTunings)this.cleverClient.create(OpenAI.FineTunings.class);
        }
        return this.fineTuningService;
    }

    @Override
    public OpenAI.Images images() {
        if (this.imageService == null) {
            this.imageService = (OpenAI.Images)this.cleverClient.create(OpenAI.Images.class);
        }
        return this.imageService;
    }

    @Override
    public OpenAI.Models models() {
        if (this.modelService == null) {
            this.modelService = (OpenAI.Models)this.cleverClient.create(OpenAI.Models.class);
        }
        return this.modelService;
    }

    @Override
    public OpenAI.Moderations moderations() {
        if (this.moderationService == null) {
            this.moderationService = (OpenAI.Moderations)this.cleverClient.create(OpenAI.Moderations.class);
        }
        return this.moderationService;
    }

    @Override
    public OpenAI.Uploads uploads() {
        if (this.uploadService == null) {
            this.uploadService = (OpenAI.Uploads)this.cleverClient.create(OpenAI.Uploads.class);
        }
        return this.uploadService;
    }

    @Override
    public OpenAIBeta2.Assistants assistants() {
        if (this.assistantService == null) {
            this.assistantService = (OpenAIBeta2.Assistants)this.cleverClient.create(OpenAIBeta2.Assistants.class);
        }
        return this.assistantService;
    }

    @Override
    public OpenAIBeta2.Threads threads() {
        if (this.threadService == null) {
            this.threadService = (OpenAIBeta2.Threads)this.cleverClient.create(OpenAIBeta2.Threads.class);
        }
        return this.threadService;
    }

    @Override
    public OpenAIBeta2.ThreadMessages threadMessages() {
        if (this.threadMessageService == null) {
            this.threadMessageService = (OpenAIBeta2.ThreadMessages)this.cleverClient.create(OpenAIBeta2.ThreadMessages.class);
        }
        return this.threadMessageService;
    }

    @Override
    public OpenAIBeta2.ThreadRuns threadRuns() {
        if (this.threadRunService == null) {
            this.threadRunService = (OpenAIBeta2.ThreadRuns)this.cleverClient.create(OpenAIBeta2.ThreadRuns.class);
        }
        return this.threadRunService;
    }

    @Override
    public OpenAIBeta2.ThreadRunSteps threadRunSteps() {
        if (this.threadRunStepService == null) {
            this.threadRunStepService = (OpenAIBeta2.ThreadRunSteps)this.cleverClient.create(OpenAIBeta2.ThreadRunSteps.class);
        }
        return this.threadRunStepService;
    }

    @Override
    public OpenAIBeta2.VectorStores vectorStores() {
        if (this.vectorStoreService == null) {
            this.vectorStoreService = (OpenAIBeta2.VectorStores)this.cleverClient.create(OpenAIBeta2.VectorStores.class);
        }
        return this.vectorStoreService;
    }

    @Override
    public OpenAIBeta2.VectorStoreFiles vectorStoreFiles() {
        if (this.vectorStoreFileService == null) {
            this.vectorStoreFileService = (OpenAIBeta2.VectorStoreFiles)this.cleverClient.create(OpenAIBeta2.VectorStoreFiles.class);
        }
        return this.vectorStoreFileService;
    }

    @Override
    public OpenAIBeta2.VectorStoreFileBatches vectorStoreFileBatches() {
        if (this.vectorStoreFileBatchService == null) {
            this.vectorStoreFileBatchService = (OpenAIBeta2.VectorStoreFileBatches)this.cleverClient.create(OpenAIBeta2.VectorStoreFileBatches.class);
        }
        return this.vectorStoreFileBatchService;
    }

    @Override
    public OpenAIRealtime realtime() {
        return this.realtime;
    }

    @Generated
    public static SimpleOpenAIBuilder builder() {
        return new SimpleOpenAIBuilder();
    }

    @Generated
    public static class SimpleOpenAIBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String organizationId;
        @Generated
        private String projectId;
        @Generated
        private String baseUrl;
        @Generated
        private HttpClient httpClient;
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private RealtimeConfig realtimeConfig;

        @Generated
        SimpleOpenAIBuilder() {
        }

        @Generated
        public SimpleOpenAIBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public SimpleOpenAIBuilder realtimeConfig(RealtimeConfig realtimeConfig) {
            this.realtimeConfig = realtimeConfig;
            return this;
        }

        @Generated
        public SimpleOpenAI build() {
            return new SimpleOpenAI(this.apiKey, this.organizationId, this.projectId, this.baseUrl, this.httpClient, this.objectMapper, this.realtimeConfig);
        }

        @Generated
        public String toString() {
            return "SimpleOpenAI.SimpleOpenAIBuilder(apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", projectId=" + this.projectId + ", baseUrl=" + this.baseUrl + ", httpClient=" + this.httpClient + ", objectMapper=" + this.objectMapper + ", realtimeConfig=" + this.realtimeConfig + ")";
        }
    }

    public static class RealtimeConfig
    extends OpenAIRealtime.BaseRealtimeConfig {
        @Required
        private String model;

        public static RealtimeConfig of(String model) {
            return ((RealtimeConfigBuilder)RealtimeConfig.builder().model(model)).build();
        }

        @Generated
        protected RealtimeConfig(RealtimeConfigBuilder<?, ?> b) {
            super(b);
            this.model = b.model;
        }

        @Generated
        public static RealtimeConfigBuilder<?, ?> builder() {
            return new RealtimeConfigBuilderImpl();
        }

        @Generated
        public String getModel() {
            return this.model;
        }

        @Generated
        private static final class RealtimeConfigBuilderImpl
        extends RealtimeConfigBuilder<RealtimeConfig, RealtimeConfigBuilderImpl> {
            @Generated
            private RealtimeConfigBuilderImpl() {
            }

            @Override
            @Generated
            protected RealtimeConfigBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public RealtimeConfig build() {
                return new RealtimeConfig(this);
            }
        }

        @Generated
        public static abstract class RealtimeConfigBuilder<C extends RealtimeConfig, B extends RealtimeConfigBuilder<C, B>>
        extends OpenAIRealtime.BaseRealtimeConfig.BaseRealtimeConfigBuilder<C, B> {
            @Generated
            private String model;

            @Generated
            public B model(String model) {
                this.model = model;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "SimpleOpenAI.RealtimeConfig.RealtimeConfigBuilder(super=" + super.toString() + ", model=" + this.model + ")";
            }
        }
    }
}

