/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.util.JsonUtil;
import io.github.sashirestela.openai.domain.realtime.BaseEvent;
import io.github.sashirestela.openai.support.Action;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIRealtime {
    private static final Logger logger = LoggerFactory.getLogger(OpenAIRealtime.class);
    private WebSocket.Builder webSocketWithHeaders;
    private String fullUrl;
    private Map<Class<?>, Consumer<Object>> eventHandlers;
    private Action openHandler;
    private BiConsumer<Integer, String> closeHandler;
    private Consumer<Throwable> errorHandler;
    private WebSocket webSocket;

    public OpenAIRealtime(HttpClient httpClient, BaseRealtimeConfig baseRealtimeConfig) {
        this.webSocketWithHeaders = this.buildWebSocketWithHeaders(httpClient, baseRealtimeConfig);
        this.fullUrl = this.buildFullUrl(baseRealtimeConfig);
        this.eventHandlers = new HashMap();
    }

    private WebSocket.Builder buildWebSocketWithHeaders(HttpClient httpClient, BaseRealtimeConfig baseRealtimeConfig) {
        WebSocket.Builder webSocketBuilder = httpClient.newWebSocketBuilder();
        for (Map.Entry<String, String> entry : baseRealtimeConfig.getHeaders().entrySet()) {
            webSocketBuilder = webSocketBuilder.header(entry.getKey(), entry.getValue());
        }
        return webSocketBuilder;
    }

    private String buildFullUrl(BaseRealtimeConfig baseRealtimeConfig) {
        StringBuilder url = new StringBuilder(baseRealtimeConfig.getEndpointUrl() + "?");
        for (Map.Entry<String, String> entry : baseRealtimeConfig.getQueryParams().entrySet()) {
            url.append(entry.getKey() + "=" + entry.getValue());
        }
        return url.toString();
    }

    public <T> void onEvent(Class<T> eventClass, Consumer<T> handler) {
        Consumer<T> genericHandler = handler;
        this.eventHandlers.put(eventClass, genericHandler);
    }

    public void onOpen(Action openHandler) {
        this.openHandler = openHandler;
    }

    public void onClose(BiConsumer<Integer, String> closeHandler) {
        this.closeHandler = closeHandler;
    }

    public void onError(Consumer<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public CompletableFuture<WebSocket> connect() {
        logger.debug("Starting connection");
        return this.webSocketWithHeaders.buildAsync(URI.create(this.fullUrl), new OpenAIRealtimeListener()).thenApply(ws -> {
            this.webSocket = ws;
            return ws;
        });
    }

    public void disconnect() {
        if (this.webSocket != null) {
            logger.debug("Closing connection");
            this.webSocket.sendClose(1000, "Closing connection");
        }
    }

    public CompletableFuture<WebSocket> send(BaseEvent clientEvent) {
        String jsonData = JsonUtil.objectToJson((Object)clientEvent);
        logger.debug("Request Event : {}", (Object)jsonData);
        return this.webSocket.sendText(jsonData, true);
    }

    @Generated
    public static OpenAIRealtimeBuilder builder() {
        return new OpenAIRealtimeBuilder();
    }

    @Generated
    public static class OpenAIRealtimeBuilder {
        @Generated
        private HttpClient httpClient;
        @Generated
        private BaseRealtimeConfig baseRealtimeConfig;

        @Generated
        OpenAIRealtimeBuilder() {
        }

        @Generated
        public OpenAIRealtimeBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public OpenAIRealtimeBuilder baseRealtimeConfig(BaseRealtimeConfig baseRealtimeConfig) {
            this.baseRealtimeConfig = baseRealtimeConfig;
            return this;
        }

        @Generated
        public OpenAIRealtime build() {
            return new OpenAIRealtime(this.httpClient, this.baseRealtimeConfig);
        }

        @Generated
        public String toString() {
            return "OpenAIRealtime.OpenAIRealtimeBuilder(httpClient=" + this.httpClient + ", baseRealtimeConfig=" + this.baseRealtimeConfig + ")";
        }
    }

    public static class BaseRealtimeConfig {
        protected String endpointUrl;
        protected Map<String, String> headers;
        protected Map<String, String> queryParams;

        @Generated
        protected BaseRealtimeConfig(BaseRealtimeConfigBuilder<?, ?> b) {
            this.endpointUrl = b.endpointUrl;
            this.headers = b.headers;
            this.queryParams = b.queryParams;
        }

        @Generated
        public static BaseRealtimeConfigBuilder<?, ?> builder() {
            return new BaseRealtimeConfigBuilderImpl();
        }

        @Generated
        public String getEndpointUrl() {
            return this.endpointUrl;
        }

        @Generated
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Generated
        public Map<String, String> getQueryParams() {
            return this.queryParams;
        }

        @Generated
        private static final class BaseRealtimeConfigBuilderImpl
        extends BaseRealtimeConfigBuilder<BaseRealtimeConfig, BaseRealtimeConfigBuilderImpl> {
            @Generated
            private BaseRealtimeConfigBuilderImpl() {
            }

            @Override
            @Generated
            protected BaseRealtimeConfigBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public BaseRealtimeConfig build() {
                return new BaseRealtimeConfig(this);
            }
        }

        @Generated
        public static abstract class BaseRealtimeConfigBuilder<C extends BaseRealtimeConfig, B extends BaseRealtimeConfigBuilder<C, B>> {
            @Generated
            private String endpointUrl;
            @Generated
            private Map<String, String> headers;
            @Generated
            private Map<String, String> queryParams;

            @Generated
            public B endpointUrl(String endpointUrl) {
                this.endpointUrl = endpointUrl;
                return this.self();
            }

            @Generated
            public B headers(Map<String, String> headers) {
                this.headers = headers;
                return this.self();
            }

            @Generated
            public B queryParams(Map<String, String> queryParams) {
                this.queryParams = queryParams;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "OpenAIRealtime.BaseRealtimeConfig.BaseRealtimeConfigBuilder(endpointUrl=" + this.endpointUrl + ", headers=" + this.headers + ", queryParams=" + this.queryParams + ")";
            }
        }
    }

    private class OpenAIRealtimeListener
    implements WebSocket.Listener {
        private StringBuilder dataBuffer = new StringBuilder();

        private OpenAIRealtimeListener() {
        }

        @Override
        public void onOpen(WebSocket webSocket) {
            logger.debug("Connection started");
            if (OpenAIRealtime.this.openHandler != null) {
                OpenAIRealtime.this.openHandler.execute();
            }
            webSocket.request(1L);
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            this.dataBuffer.append(data);
            if (last) {
                String jsonData = this.dataBuffer.toString();
                logger.debug("Response Event : {}", (Object)jsonData);
                this.dataBuffer = new StringBuilder();
                BaseEvent event = (BaseEvent)JsonUtil.jsonToObject((String)jsonData, BaseEvent.class);
                Consumer<Object> handler = OpenAIRealtime.this.eventHandlers.get(event.getClass());
                if (handler != null) {
                    handler.accept(event);
                }
            }
            webSocket.request(1L);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            logger.debug("Connection closed");
            if (OpenAIRealtime.this.closeHandler != null) {
                OpenAIRealtime.this.closeHandler.accept(statusCode, reason);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            Object errorMessage = error.getMessage();
            if (error.getCause() != null) {
                errorMessage = (String)errorMessage + "\n" + error.getCause().getMessage();
            }
            logger.debug("Connection error : {}", errorMessage);
            if (OpenAIRealtime.this.errorHandler != null) {
                OpenAIRealtime.this.errorHandler.accept(error);
            }
        }
    }
}

