/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.cleverclient.CleverClient;
import io.github.sashirestela.openai.BaseSimpleOpenAIArgs;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.OpenAIBeta2;
import io.github.sashirestela.openai.OpenAIRealtime;
import io.github.sashirestela.slimvalidator.Validator;
import io.github.sashirestela.slimvalidator.exception.ConstraintViolationException;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;

public abstract class BaseSimpleOpenAI {
    private static final String END_OF_STREAM = "[DONE]";
    protected static final String NOT_IMPLEMENTED = "Not implemented.";
    protected CleverClient cleverClient;
    protected OpenAIRealtime realtime;
    protected OpenAI.Audios audioService;
    protected OpenAI.Batches batchService;
    protected OpenAI.ChatCompletions chatCompletionService;
    protected OpenAI.Completions completionService;
    protected OpenAI.Embeddings embeddingService;
    protected OpenAI.Files fileService;
    protected OpenAI.FineTunings fineTuningService;
    protected OpenAI.Images imageService;
    protected OpenAI.Models modelService;
    protected OpenAI.Moderations moderationService;
    protected OpenAI.Uploads uploadService;
    protected OpenAIBeta2.Assistants assistantService;
    protected OpenAIBeta2.Threads threadService;
    protected OpenAIBeta2.ThreadMessages threadMessageService;
    protected OpenAIBeta2.ThreadRuns threadRunService;
    protected OpenAIBeta2.ThreadRunSteps threadRunStepService;
    protected OpenAIBeta2.VectorStores vectorStoreService;
    protected OpenAIBeta2.VectorStoreFiles vectorStoreFileService;
    protected OpenAIBeta2.VectorStoreFileBatches vectorStoreFileBatchService;

    BaseSimpleOpenAI(@NonNull BaseSimpleOpenAIArgs args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        HttpClient httpClient = Optional.ofNullable(args.getHttpClient()).orElse(HttpClient.newHttpClient());
        Consumer<Object> bodyInspector = body -> {
            Validator validator = new Validator();
            List violations = validator.validate(body);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        };
        ObjectMapper objectMapper = Optional.ofNullable(args.getObjectMapper()).orElse(new ObjectMapper());
        this.cleverClient = CleverClient.builder().httpClient(httpClient).baseUrl(args.getBaseUrl()).headers(args.getHeaders()).requestInterceptor(args.getRequestInterceptor()).bodyInspector(bodyInspector).endOfStream(END_OF_STREAM).objectMapper(objectMapper).build();
        OpenAIRealtime.BaseRealtimeConfig baseRealtimeConfig = args.getBaseRealtimeConfig();
        if (baseRealtimeConfig != null) {
            this.realtime = OpenAIRealtime.builder().httpClient(httpClient).baseRealtimeConfig(baseRealtimeConfig).build();
        }
    }

    public OpenAI.Audios audios() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Batches batches() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.ChatCompletions chatCompletions() {
        if (this.chatCompletionService == null) {
            this.chatCompletionService = (OpenAI.ChatCompletions)this.cleverClient.create(OpenAI.ChatCompletions.class);
        }
        return this.chatCompletionService;
    }

    public OpenAI.Completions completions() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Embeddings embeddings() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Files files() {
        if (this.fileService == null) {
            this.fileService = (OpenAI.Files)this.cleverClient.create(OpenAI.Files.class);
        }
        return this.fileService;
    }

    public OpenAI.FineTunings fineTunings() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Images images() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Models models() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Moderations moderations() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAI.Uploads uploads() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAIBeta2.Assistants assistants() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAIBeta2.Threads threads() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAIBeta2.ThreadMessages threadMessages() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAIBeta2.ThreadRuns threadRuns() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAIBeta2.ThreadRunSteps threadRunSteps() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAIBeta2.VectorStores vectorStores() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAIBeta2.VectorStoreFiles vectorStoreFiles() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAIBeta2.VectorStoreFileBatches vectorStoreFileBatches() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public OpenAIRealtime realtime() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Generated
    public void setCleverClient(CleverClient cleverClient) {
        this.cleverClient = cleverClient;
    }
}

