/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.tool.ToolCall;
import io.github.sashirestela.openai.domain.chat.ContentPart;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.List;

public abstract class ChatMessage {
    protected ChatRole role;

    public ChatRole getRole() {
        return this.role;
    }

    public void setRole(ChatRole role) {
        this.role = role;
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ResponseMessage
    extends ChatMessage {
        private String content;
        private List<ToolCall> toolCalls;

        public String getContent() {
            return this.content;
        }

        public List<ToolCall> getToolCalls() {
            return this.toolCalls;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setToolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ToolMessage
    extends ChatMessage {
        @Required
        private String content;
        @Required
        private String toolCallId;

        private ToolMessage(String content, String toolCallId) {
            this.role = ChatRole.TOOL;
            this.content = content;
            this.toolCallId = toolCallId;
        }

        public static ToolMessage of(String content, String toolCallId) {
            return new ToolMessage(content, toolCallId);
        }

        public String getContent() {
            return this.content;
        }

        public String getToolCallId() {
            return this.toolCallId;
        }

        public String toString() {
            return "ChatMessage.ToolMessage(content=" + this.getContent() + ", toolCallId=" + this.getToolCallId() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class AssistantMessage
    extends ChatMessage {
        @JsonInclude
        private String content;
        private String name;
        private List<ToolCall> toolCalls;

        private AssistantMessage(String content, String name, List<ToolCall> toolCalls) {
            this.role = ChatRole.ASSISTANT;
            this.content = content;
            this.name = name;
            this.toolCalls = toolCalls;
        }

        public static AssistantMessage of(String content, String name, List<ToolCall> toolCalls) {
            return new AssistantMessage(content, name, toolCalls);
        }

        public static AssistantMessage of(String content, List<ToolCall> toolCalls) {
            return new AssistantMessage(content, null, toolCalls);
        }

        public static AssistantMessage of(String content, String name) {
            return new AssistantMessage(content, name, null);
        }

        public static AssistantMessage of(String content) {
            return new AssistantMessage(content, null, null);
        }

        public String getContent() {
            return this.content;
        }

        public String getName() {
            return this.name;
        }

        public List<ToolCall> getToolCalls() {
            return this.toolCalls;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class UserMessage
    extends ChatMessage {
        @Required
        @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ContentPart.class, firstGroup=true)})
        private Object content;
        private String name;

        private UserMessage(Object content, String name) {
            this.role = ChatRole.USER;
            this.content = content;
            this.name = name;
        }

        public static UserMessage of(Object content, String name) {
            return new UserMessage(content, name);
        }

        public static UserMessage of(Object content) {
            return new UserMessage(content, null);
        }

        public Object getContent() {
            return this.content;
        }

        public String getName() {
            return this.name;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class SystemMessage
    extends ChatMessage {
        @Required
        private String content;
        private String name;

        private SystemMessage(String content, String name) {
            this.role = ChatRole.SYSTEM;
            this.content = content;
            this.name = name;
        }

        public static SystemMessage of(String content, String name) {
            return new SystemMessage(content, name);
        }

        public static SystemMessage of(String content) {
            return new SystemMessage(content, null);
        }

        public String getContent() {
            return this.content;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ChatRole {
        SYSTEM,
        USER,
        ASSISTANT,
        TOOL;

    }
}

