/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.Usage;
import io.github.sashirestela.openai.domain.chat.ChatMessage;
import java.util.List;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Chat {
    private String id;
    private String object;
    private Long created;
    private String model;
    private String systemFingerprint;
    private List<Choice> choices;
    private Usage usage;

    public ChatMessage.ResponseMessage firstMessage() {
        return this.getChoices().get(0).getMessage();
    }

    public String firstContent() {
        return this.firstMessage().getContent();
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getModel() {
        return this.model;
    }

    public String getSystemFingerprint() {
        return this.systemFingerprint;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public String toString() {
        return "Chat(id=" + this.getId() + ", object=" + this.getObject() + ", created=" + this.getCreated() + ", model=" + this.getModel() + ", systemFingerprint=" + this.getSystemFingerprint() + ", choices=" + this.getChoices() + ", usage=" + this.getUsage() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Choice {
        private Integer index;
        @JsonAlias(value={"delta"})
        private ChatMessage.ResponseMessage message;
        private String finishReason;
        private LogprobInfo logprobs;

        public Integer getIndex() {
            return this.index;
        }

        public ChatMessage.ResponseMessage getMessage() {
            return this.message;
        }

        public String getFinishReason() {
            return this.finishReason;
        }

        public LogprobInfo getLogprobs() {
            return this.logprobs;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        @JsonAlias(value={"delta"})
        public void setMessage(ChatMessage.ResponseMessage message) {
            this.message = message;
        }

        public void setFinishReason(String finishReason) {
            this.finishReason = finishReason;
        }

        public void setLogprobs(LogprobInfo logprobs) {
            this.logprobs = logprobs;
        }

        public String toString() {
            return "Chat.Choice(index=" + this.getIndex() + ", message=" + this.getMessage() + ", finishReason=" + this.getFinishReason() + ", logprobs=" + this.getLogprobs() + ")";
        }

        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class LogprobInfo {
            private List<TokenLogprob> content;

            public List<TokenLogprob> getContent() {
                return this.content;
            }

            public String toString() {
                return "Chat.Choice.LogprobInfo(content=" + this.getContent() + ")";
            }

            @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
            public static class TopLogprob {
                private String token;
                private Double logprob;
                private List<Integer> bytes;

                public String getToken() {
                    return this.token;
                }

                public Double getLogprob() {
                    return this.logprob;
                }

                public List<Integer> getBytes() {
                    return this.bytes;
                }

                public String toString() {
                    return "Chat.Choice.LogprobInfo.TopLogprob(token=" + this.getToken() + ", logprob=" + this.getLogprob() + ", bytes=" + this.getBytes() + ")";
                }
            }

            @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
            public static class TokenLogprob {
                private String token;
                private Double logprob;
                private List<Integer> bytes;
                private List<TopLogprob> topLogprobs;

                public String getToken() {
                    return this.token;
                }

                public Double getLogprob() {
                    return this.logprob;
                }

                public List<Integer> getBytes() {
                    return this.bytes;
                }

                public List<TopLogprob> getTopLogprobs() {
                    return this.topLogprobs;
                }

                public String toString() {
                    return "Chat.Choice.LogprobInfo.TokenLogprob(token=" + this.getToken() + ", logprob=" + this.getLogprob() + ", bytes=" + this.getBytes() + ", topLogprobs=" + this.getTopLogprobs() + ")";
                }
            }
        }
    }
}

