/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.Event;
import io.github.sashirestela.cleverclient.annotation.Body;
import io.github.sashirestela.cleverclient.annotation.DELETE;
import io.github.sashirestela.cleverclient.annotation.GET;
import io.github.sashirestela.cleverclient.annotation.Header;
import io.github.sashirestela.cleverclient.annotation.POST;
import io.github.sashirestela.cleverclient.annotation.Path;
import io.github.sashirestela.cleverclient.annotation.Query;
import io.github.sashirestela.cleverclient.annotation.Resource;
import io.github.sashirestela.openai.common.DeletedObject;
import io.github.sashirestela.openai.common.Page;
import io.github.sashirestela.openai.common.PageRequest;
import io.github.sashirestela.openai.domain.assistant.Assistant;
import io.github.sashirestela.openai.domain.assistant.AssistantModifyRequest;
import io.github.sashirestela.openai.domain.assistant.AssistantRequest;
import io.github.sashirestela.openai.domain.assistant.FileStatus;
import io.github.sashirestela.openai.domain.assistant.Thread;
import io.github.sashirestela.openai.domain.assistant.ThreadCreateAndRunRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadMessage;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageModifyRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadModifyRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRun;
import io.github.sashirestela.openai.domain.assistant.ThreadRunModifyRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRunRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRunStep;
import io.github.sashirestela.openai.domain.assistant.ThreadRunSubmitOutputRequest;
import io.github.sashirestela.openai.domain.assistant.VectorStore;
import io.github.sashirestela.openai.domain.assistant.VectorStoreFile;
import io.github.sashirestela.openai.domain.assistant.VectorStoreFileBatch;
import io.github.sashirestela.openai.domain.assistant.VectorStoreFileBatchRequest;
import io.github.sashirestela.openai.domain.assistant.VectorStoreFileRequest;
import io.github.sashirestela.openai.domain.assistant.VectorStoreModifyRequest;
import io.github.sashirestela.openai.domain.assistant.VectorStoreRequest;
import io.github.sashirestela.openai.domain.assistant.events.AssistantStreamEvent;
import io.github.sashirestela.openai.support.Poller;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public interface OpenAIBeta2 {

    @Resource(value="/v1/vector_stores/{vectorStoreId}/file_batches")
    @Header(name="OpenAI-Beta", value="assistants=v2")
    public static interface VectorStoreFileBatches {
        @POST
        public CompletableFuture<VectorStoreFileBatch> create(@Path(value="vectorStoreId") String var1, @Body VectorStoreFileBatchRequest var2);

        default public CompletableFuture<VectorStoreFileBatch> create(String vectorStoreId, List<String> fileIds) {
            return this.create(vectorStoreId, VectorStoreFileBatchRequest.builder().fileIds(fileIds).build());
        }

        default public VectorStoreFileBatch createAndPoll(String vectorStoreId, List<String> fileIds) {
            VectorStoreFileBatch vectorStoreFileBatch = this.create(vectorStoreId, fileIds).join();
            return Poller.builder().timeUnit(TimeUnit.SECONDS).timeValue(1).queryMethod(vsfb -> this.getOne(vsfb.getVectorStoreId(), vsfb.getId()).join()).whileMethod(vsfb -> !vsfb.getStatus().equals((Object)FileStatus.COMPLETED)).build().execute(vectorStoreFileBatch);
        }

        @GET(value="/{batchId}")
        public CompletableFuture<VectorStoreFileBatch> getOne(@Path(value="vectorStoreId") String var1, @Path(value="batchId") String var2);

        @POST(value="/{batchId}/cancel")
        public CompletableFuture<VectorStoreFileBatch> cancel(@Path(value="vectorStoreId") String var1, @Path(value="batchId") String var2);

        @GET(value="/{batchId}/files")
        public CompletableFuture<Page<VectorStoreFile>> getFiles(@Path(value="vectorStoreId") String var1, @Path(value="batchId") String var2, @Query PageRequest var3, @Query(value="filter") FileStatus var4);

        default public CompletableFuture<Page<VectorStoreFile>> getFiles(String vectorStoreId, String batchId) {
            return this.getFiles(vectorStoreId, batchId, PageRequest.builder().build(), null);
        }
    }

    @Resource(value="/v1/vector_stores/{vectorStoreId}/files")
    @Header(name="OpenAI-Beta", value="assistants=v2")
    public static interface VectorStoreFiles {
        @POST
        public CompletableFuture<VectorStoreFile> create(@Path(value="vectorStoreId") String var1, @Body VectorStoreFileRequest var2);

        default public CompletableFuture<VectorStoreFile> create(String vectorStoreId, String fileId) {
            return this.create(vectorStoreId, VectorStoreFileRequest.builder().fileId(fileId).build());
        }

        default public VectorStoreFile createAndPoll(String vectorStoreId, String fileId) {
            VectorStoreFile vectorStoreFile = this.create(vectorStoreId, fileId).join();
            return Poller.builder().timeUnit(TimeUnit.SECONDS).timeValue(1).queryMethod(vsf -> this.getOne(vsf.getVectorStoreId(), vsf.getId()).join()).whileMethod(vsf -> !vsf.getStatus().equals((Object)FileStatus.COMPLETED)).build().execute(vectorStoreFile);
        }

        @GET
        public CompletableFuture<Page<VectorStoreFile>> getList(@Path(value="vectorStoreId") String var1, @Query PageRequest var2, @Query(value="filter") FileStatus var3);

        default public CompletableFuture<Page<VectorStoreFile>> getList(String vectorStoreId) {
            return this.getList(vectorStoreId, PageRequest.builder().build(), null);
        }

        @GET(value="/{fileId}")
        public CompletableFuture<VectorStoreFile> getOne(@Path(value="vectorStoreId") String var1, @Path(value="fileId") String var2);

        @DELETE(value="/{fileId}")
        public CompletableFuture<DeletedObject> delete(@Path(value="vectorStoreId") String var1, @Path(value="fileId") String var2);
    }

    @Resource(value="/v1/vector_stores")
    @Header(name="OpenAI-Beta", value="assistants=v2")
    public static interface VectorStores {
        @POST
        public CompletableFuture<VectorStore> create(@Body VectorStoreRequest var1);

        default public CompletableFuture<VectorStore> create() {
            return this.create(VectorStoreRequest.builder().build());
        }

        default public VectorStore createAndPoll(VectorStoreRequest request) {
            VectorStore vectorStore = this.create(request).join();
            return Poller.builder().timeUnit(TimeUnit.SECONDS).timeValue(1).queryMethod(vs -> this.getOne(vs.getId()).join()).whileMethod(vs -> !vs.getStatus().equals((Object)VectorStore.VectorStoreStatus.COMPLETED) || vs.getFileCounts().getCompleted() != vs.getFileCounts().getTotal()).build().execute(vectorStore);
        }

        @GET
        public CompletableFuture<Page<VectorStore>> getList(@Query PageRequest var1);

        default public CompletableFuture<Page<VectorStore>> getList() {
            return this.getList(PageRequest.builder().build());
        }

        @GET(value="/{vectorStoreId}")
        public CompletableFuture<VectorStore> getOne(@Path(value="vectorStoreId") String var1);

        @POST(value="/{vectorStoreId}")
        public CompletableFuture<VectorStore> modify(@Path(value="vectorStoreId") String var1, @Body VectorStoreModifyRequest var2);

        @DELETE(value="/{vectorStoreId}")
        public CompletableFuture<DeletedObject> delete(@Path(value="vectorStoreId") String var1);
    }

    @Resource(value="/v1/threads/{threadId}/runs/{runId}/steps")
    @Header(name="OpenAI-Beta", value="assistants=v2")
    public static interface ThreadRunSteps {
        @GET
        public CompletableFuture<Page<ThreadRunStep>> getList(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Query PageRequest var3);

        default public CompletableFuture<Page<ThreadRunStep>> getList(String threadId, String runId) {
            return this.getList(threadId, runId, PageRequest.builder().build());
        }

        @GET(value="/{stepId}")
        public CompletableFuture<ThreadRunStep> getOne(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Path(value="stepId") String var3);
    }

    @Resource(value="/v1/threads")
    @Header(name="OpenAI-Beta", value="assistants=v2")
    public static interface ThreadRuns {
        @POST(value="/{threadId}/runs")
        public CompletableFuture<ThreadRun> createPrimitive(@Path(value="threadId") String var1, @Body ThreadRunRequest var2);

        default public CompletableFuture<ThreadRun> create(String threadId, ThreadRunRequest request) {
            ThreadRunRequest newRequest = request.withStream(Boolean.FALSE);
            return this.createPrimitive(threadId, newRequest);
        }

        default public ThreadRun createAndPoll(String threadId, ThreadRunRequest request) {
            ThreadRun threadRun = this.create(threadId, request).join();
            return Poller.builder().timeUnit(TimeUnit.SECONDS).timeValue(1).queryMethod(tr -> this.getOne(tr.getThreadId(), tr.getId()).join()).whileMethod(tr -> tr.getStatus().equals((Object)ThreadRun.RunStatus.IN_PROGRESS)).build().execute(threadRun);
        }

        @POST(value="/{threadId}/runs")
        @AssistantStreamEvent
        public CompletableFuture<Stream<Event>> createStreamPrimitive(@Path(value="threadId") String var1, @Body ThreadRunRequest var2);

        default public CompletableFuture<Stream<Event>> createStream(String threadId, ThreadRunRequest request) {
            ThreadRunRequest newRequest = request.withStream(Boolean.TRUE);
            return this.createStreamPrimitive(threadId, newRequest);
        }

        @POST(value="/runs")
        public CompletableFuture<ThreadRun> createThreadAndRunPrimitive(@Body ThreadCreateAndRunRequest var1);

        default public CompletableFuture<ThreadRun> createThreadAndRun(ThreadCreateAndRunRequest request) {
            ThreadCreateAndRunRequest newRequest = request.withStream(Boolean.FALSE);
            return this.createThreadAndRunPrimitive(newRequest);
        }

        default public ThreadRun createThreadAndRunAndPoll(ThreadCreateAndRunRequest request) {
            ThreadRun threadRun = this.createThreadAndRun(request).join();
            return Poller.builder().timeUnit(TimeUnit.SECONDS).timeValue(1).queryMethod(tr -> this.getOne(tr.getThreadId(), tr.getId()).join()).whileMethod(tr -> tr.getStatus().equals((Object)ThreadRun.RunStatus.IN_PROGRESS)).build().execute(threadRun);
        }

        @POST(value="/runs")
        @AssistantStreamEvent
        public CompletableFuture<Stream<Event>> createThreadAndRunStreamPrimitive(@Body ThreadCreateAndRunRequest var1);

        default public CompletableFuture<Stream<Event>> createThreadAndRunStream(ThreadCreateAndRunRequest request) {
            ThreadCreateAndRunRequest newRequest = request.withStream(Boolean.TRUE);
            return this.createThreadAndRunStreamPrimitive(newRequest);
        }

        @GET(value="/{threadId}/runs")
        public CompletableFuture<Page<ThreadRun>> getList(@Path(value="threadId") String var1, @Query PageRequest var2);

        default public CompletableFuture<Page<ThreadRun>> getList(String threadId) {
            return this.getList(threadId, PageRequest.builder().build());
        }

        @GET(value="/{threadId}/runs/{runId}")
        public CompletableFuture<ThreadRun> getOne(@Path(value="threadId") String var1, @Path(value="runId") String var2);

        @POST(value="/{threadId}/runs/{runId}")
        public CompletableFuture<ThreadRun> modify(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Body ThreadRunModifyRequest var3);

        @POST(value="/{threadId}/runs/{runId}/cancel")
        public CompletableFuture<ThreadRun> cancel(@Path(value="threadId") String var1, @Path(value="runId") String var2);

        @POST(value="/{threadId}/runs/{runId}/submit_tool_outputs")
        public CompletableFuture<ThreadRun> submitToolOutputPrimitive(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Body ThreadRunSubmitOutputRequest var3);

        default public CompletableFuture<ThreadRun> submitToolOutput(String threadId, String runId, ThreadRunSubmitOutputRequest request) {
            ThreadRunSubmitOutputRequest newRequest = request.withStream(Boolean.FALSE);
            return this.submitToolOutputPrimitive(threadId, runId, newRequest);
        }

        default public ThreadRun submitToolOutputAndPoll(String threadId, String runId, ThreadRunSubmitOutputRequest request) {
            ThreadRun threadRun = this.submitToolOutput(threadId, runId, request).join();
            return Poller.builder().timeUnit(TimeUnit.SECONDS).timeValue(1).queryMethod(tr -> this.getOne(tr.getThreadId(), tr.getId()).join()).whileMethod(tr -> tr.getStatus().equals((Object)ThreadRun.RunStatus.IN_PROGRESS)).build().execute(threadRun);
        }

        @POST(value="/{threadId}/runs/{runId}/submit_tool_outputs")
        @AssistantStreamEvent
        public CompletableFuture<Stream<Event>> submitToolOutputStreamPrimitive(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Body ThreadRunSubmitOutputRequest var3);

        default public CompletableFuture<Stream<Event>> submitToolOutputStream(String threadId, String runId, ThreadRunSubmitOutputRequest request) {
            ThreadRunSubmitOutputRequest newRequest = request.withStream(Boolean.TRUE);
            return this.submitToolOutputStreamPrimitive(threadId, runId, newRequest);
        }
    }

    @Resource(value="/v1/threads/{threadId}/messages")
    @Header(name="OpenAI-Beta", value="assistants=v2")
    public static interface ThreadMessages {
        @POST
        public CompletableFuture<ThreadMessage> create(@Path(value="threadId") String var1, @Body ThreadMessageRequest var2);

        @GET
        public CompletableFuture<Page<ThreadMessage>> getList(@Path(value="threadId") String var1, @Query PageRequest var2, @Query(value="run_id") String var3);

        default public CompletableFuture<Page<ThreadMessage>> getList(String threadId) {
            return this.getList(threadId, PageRequest.builder().build(), null);
        }

        @GET(value="/{messageId}")
        public CompletableFuture<ThreadMessage> getOne(@Path(value="threadId") String var1, @Path(value="messageId") String var2);

        @POST(value="/{messageId}")
        public CompletableFuture<ThreadMessage> modify(@Path(value="threadId") String var1, @Path(value="messageId") String var2, @Body ThreadMessageModifyRequest var3);

        @DELETE(value="/{messageId}")
        public CompletableFuture<DeletedObject> delete(@Path(value="threadId") String var1, @Path(value="messageId") String var2);
    }

    @Resource(value="/v1/threads")
    @Header(name="OpenAI-Beta", value="assistants=v2")
    public static interface Threads {
        @POST
        public CompletableFuture<Thread> create(@Body ThreadRequest var1);

        default public CompletableFuture<Thread> create() {
            return this.create(ThreadRequest.builder().build());
        }

        @GET(value="/{threadId}")
        public CompletableFuture<Thread> getOne(@Path(value="threadId") String var1);

        @POST(value="/{threadId}")
        public CompletableFuture<Thread> modify(@Path(value="threadId") String var1, @Body ThreadModifyRequest var2);

        @DELETE(value="/{threadId}")
        public CompletableFuture<DeletedObject> delete(@Path(value="threadId") String var1);
    }

    @Resource(value="/v1/assistants")
    @Header(name="OpenAI-Beta", value="assistants=v2")
    public static interface Assistants {
        @POST
        public CompletableFuture<Assistant> create(@Body AssistantRequest var1);

        default public CompletableFuture<Assistant> create(String model) {
            return this.create(AssistantRequest.builder().model(model).build());
        }

        @GET
        public CompletableFuture<Page<Assistant>> getList(@Query PageRequest var1);

        default public CompletableFuture<Page<Assistant>> getList() {
            return this.getList(PageRequest.builder().build());
        }

        @GET(value="/{assistantId}")
        public CompletableFuture<Assistant> getOne(@Path(value="assistantId") String var1);

        @POST(value="/{assistantId}")
        public CompletableFuture<Assistant> modify(@Path(value="assistantId") String var1, @Body AssistantModifyRequest var2);

        @DELETE(value="/{assistantId}")
        public CompletableFuture<DeletedObject> delete(@Path(value="assistantId") String var1);
    }
}

