/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Required;

public abstract class ContentPart {
    protected ContentPartType type;

    public ContentPartType getType() {
        return this.type;
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ContentPartImage
    extends ContentPart {
        @Required
        private ImageUrl imageUrl;

        private ContentPartImage(ImageUrl imageUrl) {
            this.type = ContentPartType.IMAGE_URL;
            this.imageUrl = imageUrl;
        }

        public static ContentPartImage of(ImageUrl imageUrl) {
            return new ContentPartImage(imageUrl);
        }

        public ImageUrl getImageUrl() {
            return this.imageUrl;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public static class ImageUrl {
            @Required
            private String url;
            private ImageDetail detail;

            private ImageUrl(String url, ImageDetail detail) {
                this.url = url;
                this.detail = detail;
            }

            public static ImageUrl of(String url, ImageDetail detail) {
                return new ImageUrl(url, detail);
            }

            public static ImageUrl of(String url) {
                return new ImageUrl(url, null);
            }

            public String getUrl() {
                return this.url;
            }

            public ImageDetail getDetail() {
                return this.detail;
            }

            public static enum ImageDetail {
                AUTO,
                LOW,
                HIGH;

            }
        }
    }

    public static class ContentPartText
    extends ContentPart {
        @Required
        private String text;

        private ContentPartText(String text) {
            this.type = ContentPartType.TEXT;
            this.text = text;
        }

        public static ContentPartText of(String text) {
            return new ContentPartText(text);
        }

        public String getText() {
            return this.text;
        }
    }

    public static enum ContentPartType {
        TEXT,
        IMAGE_URL;

    }
}

