/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.cleverclient.util.UnixTimestampDeserializer;
import io.github.sashirestela.openai.domain.OpenAIUsage;
import io.github.sashirestela.openai.domain.ToolCall;
import io.github.sashirestela.openai.domain.assistant.AssistantTool;
import io.github.sashirestela.openai.domain.assistant.ThreadRunAction;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadRun {
    private String id;
    private String object;
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    private ZonedDateTime createdAt;
    private String threadId;
    private String assistantId;
    private String status;
    private ThreadRunAction requiredAction;
    private Error lastError;
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    private ZonedDateTime expiresAt;
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    private ZonedDateTime startedAt;
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    private ZonedDateTime cancelledAt;
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    private ZonedDateTime failedAt;
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    private ZonedDateTime completedAt;
    private String model;
    private String instructions;
    private List<AssistantTool> tools;
    private List<String> fileIds;
    private Map<String, String> metadata;
    private OpenAIUsage usage;
    private Double temperature;

    public boolean isActionRequired() {
        return this.requiredAction != null;
    }

    public List<ToolCall> getRequiredToolCalls() {
        if (this.requiredAction != null && this.requiredAction.getSubmitToolOutputs() != null && this.requiredAction.getSubmitToolOutputs().getToolCalls() != null) {
            return this.requiredAction.getSubmitToolOutputs().getToolCalls();
        }
        return List.of();
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getStatus() {
        return this.status;
    }

    public ThreadRunAction getRequiredAction() {
        return this.requiredAction;
    }

    public Error getLastError() {
        return this.lastError;
    }

    public ZonedDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public ZonedDateTime getStartedAt() {
        return this.startedAt;
    }

    public ZonedDateTime getCancelledAt() {
        return this.cancelledAt;
    }

    public ZonedDateTime getFailedAt() {
        return this.failedAt;
    }

    public ZonedDateTime getCompletedAt() {
        return this.completedAt;
    }

    public String getModel() {
        return this.model;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<AssistantTool> getTools() {
        return this.tools;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public OpenAIUsage getUsage() {
        return this.usage;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public String toString() {
        return "ThreadRun(id=" + this.getId() + ", object=" + this.getObject() + ", createdAt=" + this.getCreatedAt() + ", threadId=" + this.getThreadId() + ", assistantId=" + this.getAssistantId() + ", status=" + this.getStatus() + ", requiredAction=" + this.getRequiredAction() + ", lastError=" + this.getLastError() + ", expiresAt=" + this.getExpiresAt() + ", startedAt=" + this.getStartedAt() + ", cancelledAt=" + this.getCancelledAt() + ", failedAt=" + this.getFailedAt() + ", completedAt=" + this.getCompletedAt() + ", model=" + this.getModel() + ", instructions=" + this.getInstructions() + ", tools=" + this.getTools() + ", fileIds=" + this.getFileIds() + ", metadata=" + this.getMetadata() + ", usage=" + this.getUsage() + ", temperature=" + this.getTemperature() + ")";
    }

    public static class Error {
        private String code;
        private String message;

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "ThreadRun.Error(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
        }
    }

    public final class Status {
        public static final String QUEUED = "queued";
        public static final String IN_PROGRESS = "in_progress";
        public static final String REQUIRES_ACTION = "requires_action";
        public static final String CANCELLING = "cancelling";
        public static final String CANCELLED = "cancelled";
        public static final String FAILED = "failed";
        public static final String COMPLETED = "completed";
        public static final String EXPIRED = "expired";

        private Status() {
        }
    }
}

