/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.openai.BaseSimpleOpenAI;
import io.github.sashirestela.openai.BaseSimpleOpenAIArgs;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.OpenAIBeta;
import java.lang.invoke.CallSite;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class SimpleOpenAIAnyscale
extends BaseSimpleOpenAI {
    public SimpleOpenAIAnyscale(@NonNull String apiKey, String baseUrl, HttpClient httpClient) {
        super(SimpleOpenAIAnyscale.prepareBaseSimpleOpenAIArgs(apiKey, baseUrl, httpClient));
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
    }

    public static BaseSimpleOpenAIArgs prepareBaseSimpleOpenAIArgs(String apiKey, String baseUrl, HttpClient httpClient) {
        Map<String, CallSite> headers = Map.of("Authorization", "Bearer " + apiKey);
        return BaseSimpleOpenAIArgs.builder().baseUrl(Optional.ofNullable(baseUrl).orElse("https://api.endpoints.anyscale.com")).headers(headers).httpClient(httpClient).build();
    }

    @Override
    public OpenAI.Files files() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public OpenAIBeta.Assistants assistants() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public OpenAIBeta.Threads threads() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public static SimpleOpenAIAnyscaleBuilder builder() {
        return new SimpleOpenAIAnyscaleBuilder();
    }

    public static class SimpleOpenAIAnyscaleBuilder {
        private String apiKey;
        private String baseUrl;
        private HttpClient httpClient;

        SimpleOpenAIAnyscaleBuilder() {
        }

        public SimpleOpenAIAnyscaleBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        public SimpleOpenAIAnyscaleBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public SimpleOpenAIAnyscaleBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SimpleOpenAIAnyscale build() {
            return new SimpleOpenAIAnyscale(this.apiKey, this.baseUrl, this.httpClient);
        }

        public String toString() {
            return "SimpleOpenAIAnyscale.SimpleOpenAIAnyscaleBuilder(apiKey=" + this.apiKey + ", baseUrl=" + this.baseUrl + ", httpClient=" + this.httpClient + ")";
        }
    }
}

