/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.embedding;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.embedding.EncodingFormat;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class EmbeddingRequest {
    @Required
    private String model;
    @Required
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=String.class, firstGroup=true), @ObjectType(baseClass=Integer.class, firstGroup=true), @ObjectType(baseClass=Integer.class, firstGroup=true, secondGroup=true)})
    private Object input;
    private EncodingFormat encodingFormat;
    @Range(min=1.0)
    private Integer dimensions;
    private String user;

    EmbeddingRequest(String model, Object input, EncodingFormat encodingFormat, Integer dimensions, String user) {
        this.model = model;
        this.input = input;
        this.encodingFormat = encodingFormat;
        this.dimensions = dimensions;
        this.user = user;
    }

    public static EmbeddingRequestBuilder builder() {
        return new EmbeddingRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public Object getInput() {
        return this.input;
    }

    public EncodingFormat getEncodingFormat() {
        return this.encodingFormat;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public String getUser() {
        return this.user;
    }

    public EmbeddingRequest withEncodingFormat(EncodingFormat encodingFormat) {
        return this.encodingFormat == encodingFormat ? this : new EmbeddingRequest(this.model, this.input, encodingFormat, this.dimensions, this.user);
    }

    public static class EmbeddingRequestBuilder {
        private String model;
        private Object input;
        private EncodingFormat encodingFormat;
        private Integer dimensions;
        private String user;

        EmbeddingRequestBuilder() {
        }

        public EmbeddingRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public EmbeddingRequestBuilder input(Object input) {
            this.input = input;
            return this;
        }

        public EmbeddingRequestBuilder encodingFormat(EncodingFormat encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        public EmbeddingRequestBuilder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public EmbeddingRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public EmbeddingRequest build() {
            return new EmbeddingRequest(this.model, this.input, this.encodingFormat, this.dimensions, this.user);
        }

        public String toString() {
            return "EmbeddingRequest.EmbeddingRequestBuilder(model=" + this.model + ", input=" + this.input + ", encodingFormat=" + this.encodingFormat + ", dimensions=" + this.dimensions + ", user=" + this.user + ")";
        }
    }
}

