/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageRequest;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadMessageList {
    private List<ThreadMessageRequest> messages;
    @Size(max=16)
    private Map<String, String> metadata;

    ThreadMessageList(List<ThreadMessageRequest> messages, Map<String, String> metadata) {
        this.messages = messages;
        this.metadata = metadata;
    }

    public static ThreadMessageListBuilder builder() {
        return new ThreadMessageListBuilder();
    }

    public List<ThreadMessageRequest> getMessages() {
        return this.messages;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class ThreadMessageListBuilder {
        private ArrayList<ThreadMessageRequest> messages;
        private Map<String, String> metadata;

        ThreadMessageListBuilder() {
        }

        public ThreadMessageListBuilder message(ThreadMessageRequest message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        public ThreadMessageListBuilder messages(Collection<? extends ThreadMessageRequest> messages) {
            if (messages == null) {
                throw new NullPointerException("messages cannot be null");
            }
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        public ThreadMessageListBuilder clearMessages() {
            if (this.messages != null) {
                this.messages.clear();
            }
            return this;
        }

        public ThreadMessageListBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ThreadMessageList build() {
            List<ThreadMessageRequest> messages;
            switch (this.messages == null ? 0 : this.messages.size()) {
                case 0: {
                    messages = Collections.emptyList();
                    break;
                }
                case 1: {
                    messages = Collections.singletonList(this.messages.get(0));
                    break;
                }
                default: {
                    messages = Collections.unmodifiableList(new ArrayList<ThreadMessageRequest>(this.messages));
                }
            }
            return new ThreadMessageList(messages, this.metadata);
        }

        public String toString() {
            return "ThreadMessageList.ThreadMessageListBuilder(messages=" + this.messages + ", metadata=" + this.metadata + ")";
        }
    }
}

