/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.finetuning;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.finetuning.IntegrationType;
import io.github.sashirestela.openai.domain.finetuning.WandbIntegration;
import io.github.sashirestela.slimvalidator.constraints.Required;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Integration {
    @Required
    private IntegrationType type;
    @Required
    private WandbIntegration wandb;

    public static IntegrationBuilder builder() {
        return new IntegrationBuilder();
    }

    public Integration() {
    }

    public Integration(IntegrationType type, WandbIntegration wandb) {
        this.type = type;
        this.wandb = wandb;
    }

    public IntegrationType getType() {
        return this.type;
    }

    public WandbIntegration getWandb() {
        return this.wandb;
    }

    public static class IntegrationBuilder {
        private IntegrationType type;
        private WandbIntegration wandb;

        IntegrationBuilder() {
        }

        public IntegrationBuilder type(IntegrationType type) {
            this.type = type;
            return this;
        }

        public IntegrationBuilder wandb(WandbIntegration wandb) {
            this.wandb = wandb;
            return this;
        }

        public Integration build() {
            return new Integration(this.type, this.wandb);
        }

        public String toString() {
            return "Integration.IntegrationBuilder(type=" + this.type + ", wandb=" + this.wandb + ")";
        }
    }
}

