/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat.tool;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.github.sashirestela.openai.function.Functional;
import io.github.sashirestela.openai.function.ParametersSerializer;
import io.github.sashirestela.slimvalidator.constraints.Required;

public class ChatFunction {
    @Required
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @Required
    @JsonSerialize(using=ParametersSerializer.class)
    @JsonProperty(value="parameters")
    private Class<? extends Functional> functionalClass;

    ChatFunction(String name, String description, Class<? extends Functional> functionalClass) {
        this.name = name;
        this.description = description;
        this.functionalClass = functionalClass;
    }

    public static ChatFunctionBuilder builder() {
        return new ChatFunctionBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<? extends Functional> getFunctionalClass() {
        return this.functionalClass;
    }

    public static class ChatFunctionBuilder {
        private String name;
        private String description;
        private Class<? extends Functional> functionalClass;

        ChatFunctionBuilder() {
        }

        public ChatFunctionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChatFunctionBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="parameters")
        public ChatFunctionBuilder functionalClass(Class<? extends Functional> functionalClass) {
            this.functionalClass = functionalClass;
            return this;
        }

        public ChatFunction build() {
            return new ChatFunction(this.name, this.description, this.functionalClass);
        }

        public String toString() {
            return "ChatFunction.ChatFunctionBuilder(name=" + this.name + ", description=" + this.description + ", functionalClass=" + this.functionalClass + ")";
        }
    }
}

