/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.finetuning;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.finetuning.HyperParams;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class FineTuningRequest {
    @NonNull
    private String model;
    @NonNull
    private String trainingFile;
    private String validationFile;
    private HyperParams hyperparameters;
    private String suffix;

    FineTuningRequest(@NonNull String model, @NonNull String trainingFile, String validationFile, HyperParams hyperparameters, String suffix) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (trainingFile == null) {
            throw new NullPointerException("trainingFile is marked non-null but is null");
        }
        this.model = model;
        this.trainingFile = trainingFile;
        this.validationFile = validationFile;
        this.hyperparameters = hyperparameters;
        this.suffix = suffix;
    }

    public static FineTuningRequestBuilder builder() {
        return new FineTuningRequestBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getTrainingFile() {
        return this.trainingFile;
    }

    public String getValidationFile() {
        return this.validationFile;
    }

    public HyperParams getHyperparameters() {
        return this.hyperparameters;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public static class FineTuningRequestBuilder {
        private String model;
        private String trainingFile;
        private String validationFile;
        private HyperParams hyperparameters;
        private String suffix;

        FineTuningRequestBuilder() {
        }

        public FineTuningRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public FineTuningRequestBuilder trainingFile(@NonNull String trainingFile) {
            if (trainingFile == null) {
                throw new NullPointerException("trainingFile is marked non-null but is null");
            }
            this.trainingFile = trainingFile;
            return this;
        }

        public FineTuningRequestBuilder validationFile(String validationFile) {
            this.validationFile = validationFile;
            return this;
        }

        public FineTuningRequestBuilder hyperparameters(HyperParams hyperparameters) {
            this.hyperparameters = hyperparameters;
            return this;
        }

        public FineTuningRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public FineTuningRequest build() {
            return new FineTuningRequest(this.model, this.trainingFile, this.validationFile, this.hyperparameters, this.suffix);
        }

        public String toString() {
            return "FineTuningRequest.FineTuningRequestBuilder(model=" + this.model + ", trainingFile=" + this.trainingFile + ", validationFile=" + this.validationFile + ", hyperparameters=" + this.hyperparameters + ", suffix=" + this.suffix + ")";
        }
    }
}

