/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.openai.BaseSimpleOpenAI;
import io.github.sashirestela.openai.BaseSimpleOpenAIArgs;
import io.github.sashirestela.openai.OpenAI;
import java.net.http.HttpClient;
import java.util.HashMap;
import java.util.Optional;
import lombok.NonNull;

public class SimpleOpenAI
extends BaseSimpleOpenAI {
    private OpenAI.Audios audioService;
    private OpenAI.Completions completionService;
    private OpenAI.Embeddings embeddingService;
    private OpenAI.Files fileService;
    private OpenAI.FineTunings fineTuningService;
    private OpenAI.Images imageService;
    private OpenAI.Models modelService;
    private OpenAI.Moderations moderationService;
    private OpenAI.Assistants assistantService;
    private OpenAI.Threads threadService;

    public SimpleOpenAI(@NonNull String apiKey, String organizationId, String baseUrl, HttpClient httpClient) {
        super(SimpleOpenAI.prepareBaseSimpleOpenAIArgs(apiKey, organizationId, baseUrl, httpClient));
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
    }

    public static BaseSimpleOpenAIArgs prepareBaseSimpleOpenAIArgs(String apiKey, String organizationId, String baseUrl, HttpClient httpClient) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + apiKey);
        if (organizationId != null) {
            headers.put("OpenAI-Organization", organizationId);
        }
        return BaseSimpleOpenAIArgs.builder().baseUrl(Optional.ofNullable(baseUrl).orElse("https://api.openai.com")).headers(headers).httpClient(httpClient).build();
    }

    @Override
    public OpenAI.Audios audios() {
        if (this.audioService == null) {
            this.audioService = (OpenAI.Audios)this.cleverClient.create(OpenAI.Audios.class);
        }
        return this.audioService;
    }

    @Override
    public OpenAI.Completions completions() {
        if (this.completionService == null) {
            this.completionService = (OpenAI.Completions)this.cleverClient.create(OpenAI.Completions.class);
        }
        return this.completionService;
    }

    @Override
    public OpenAI.Embeddings embeddings() {
        if (this.embeddingService == null) {
            this.embeddingService = (OpenAI.Embeddings)this.cleverClient.create(OpenAI.Embeddings.class);
        }
        return this.embeddingService;
    }

    @Override
    public OpenAI.Files files() {
        if (this.fileService == null) {
            this.fileService = (OpenAI.Files)this.cleverClient.create(OpenAI.Files.class);
        }
        return this.fileService;
    }

    @Override
    public OpenAI.FineTunings fineTunings() {
        if (this.fineTuningService == null) {
            this.fineTuningService = (OpenAI.FineTunings)this.cleverClient.create(OpenAI.FineTunings.class);
        }
        return this.fineTuningService;
    }

    @Override
    public OpenAI.Images images() {
        if (this.imageService == null) {
            this.imageService = (OpenAI.Images)this.cleverClient.create(OpenAI.Images.class);
        }
        return this.imageService;
    }

    @Override
    public OpenAI.Models models() {
        if (this.modelService == null) {
            this.modelService = (OpenAI.Models)this.cleverClient.create(OpenAI.Models.class);
        }
        return this.modelService;
    }

    @Override
    public OpenAI.Moderations moderations() {
        if (this.moderationService == null) {
            this.moderationService = (OpenAI.Moderations)this.cleverClient.create(OpenAI.Moderations.class);
        }
        return this.moderationService;
    }

    @Override
    public OpenAI.Assistants assistants() {
        if (this.assistantService == null) {
            this.assistantService = (OpenAI.Assistants)this.cleverClient.create(OpenAI.Assistants.class);
        }
        return this.assistantService;
    }

    @Override
    public OpenAI.Threads threads() {
        if (this.threadService == null) {
            this.threadService = (OpenAI.Threads)this.cleverClient.create(OpenAI.Threads.class);
        }
        return this.threadService;
    }

    public static SimpleOpenAIBuilder builder() {
        return new SimpleOpenAIBuilder();
    }

    public static class SimpleOpenAIBuilder {
        private String apiKey;
        private String organizationId;
        private String baseUrl;
        private HttpClient httpClient;

        SimpleOpenAIBuilder() {
        }

        public SimpleOpenAIBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        public SimpleOpenAIBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public SimpleOpenAIBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public SimpleOpenAIBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SimpleOpenAI build() {
            return new SimpleOpenAI(this.apiKey, this.organizationId, this.baseUrl, this.httpClient);
        }

        public String toString() {
            return "SimpleOpenAI.SimpleOpenAIBuilder(apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", baseUrl=" + this.baseUrl + ", httpClient=" + this.httpClient + ")";
        }
    }
}

