/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.finetuning;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.sashirestela.openai.SimpleUncheckedException;

public class HyperParams {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="batch_size")
    private Object batchSize;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="learning_rate_multiplier")
    private Object learningRateMultiplier;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="n_epochs")
    private Object numberEpochs;

    public HyperParams(Object batchSize, Object learningRateMultiplier, Object numberEpochs) {
        if (batchSize != null && !(batchSize instanceof Integer) && !(batchSize instanceof String)) {
            throw new SimpleUncheckedException("The field batchSize must be Integer or String classes.", null, null);
        }
        if (learningRateMultiplier != null && !(learningRateMultiplier instanceof Double) && !(learningRateMultiplier instanceof String)) {
            throw new SimpleUncheckedException("The field learningRateMultiplier must be Double or String classes.", null, null);
        }
        if (numberEpochs != null && !(numberEpochs instanceof Integer) && !(numberEpochs instanceof String)) {
            throw new SimpleUncheckedException("The field numberEpochs must be Integer or String classes.", null, null);
        }
        this.batchSize = batchSize;
        this.learningRateMultiplier = learningRateMultiplier;
        this.numberEpochs = numberEpochs;
    }

    public static HyperParamsBuilder builder() {
        return new HyperParamsBuilder();
    }

    public HyperParams() {
    }

    public Object getBatchSize() {
        return this.batchSize;
    }

    public Object getLearningRateMultiplier() {
        return this.learningRateMultiplier;
    }

    public Object getNumberEpochs() {
        return this.numberEpochs;
    }

    public String toString() {
        return "HyperParams(batchSize=" + this.getBatchSize() + ", learningRateMultiplier=" + this.getLearningRateMultiplier() + ", numberEpochs=" + this.getNumberEpochs() + ")";
    }

    public static class HyperParamsBuilder {
        private Object batchSize;
        private Object learningRateMultiplier;
        private Object numberEpochs;

        HyperParamsBuilder() {
        }

        public HyperParamsBuilder batchSize(Object batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public HyperParamsBuilder learningRateMultiplier(Object learningRateMultiplier) {
            this.learningRateMultiplier = learningRateMultiplier;
            return this;
        }

        public HyperParamsBuilder numberEpochs(Object numberEpochs) {
            this.numberEpochs = numberEpochs;
            return this;
        }

        public HyperParams build() {
            return new HyperParams(this.batchSize, this.learningRateMultiplier, this.numberEpochs);
        }

        public String toString() {
            return "HyperParams.HyperParamsBuilder(batchSize=" + this.batchSize + ", learningRateMultiplier=" + this.learningRateMultiplier + ", numberEpochs=" + this.numberEpochs + ")";
        }
    }
}

