/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.finetuning;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.sashirestela.openai.domain.finetuning.HyperParams;
import lombok.NonNull;

public class FineTuningRequest {
    @NonNull
    private String model;
    @JsonProperty(value="training_file")
    @NonNull
    private String trainingFile;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="validation_file")
    private String validationFile;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="hyperparameters")
    private HyperParams hyperParameters;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String suffix;

    FineTuningRequest(@NonNull String model, @NonNull String trainingFile, String validationFile, HyperParams hyperParameters, String suffix) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (trainingFile == null) {
            throw new NullPointerException("trainingFile is marked non-null but is null");
        }
        this.model = model;
        this.trainingFile = trainingFile;
        this.validationFile = validationFile;
        this.hyperParameters = hyperParameters;
        this.suffix = suffix;
    }

    public static FineTuningRequestBuilder builder() {
        return new FineTuningRequestBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getTrainingFile() {
        return this.trainingFile;
    }

    public String getValidationFile() {
        return this.validationFile;
    }

    public HyperParams getHyperParameters() {
        return this.hyperParameters;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public static class FineTuningRequestBuilder {
        private String model;
        private String trainingFile;
        private String validationFile;
        private HyperParams hyperParameters;
        private String suffix;

        FineTuningRequestBuilder() {
        }

        public FineTuningRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        @JsonProperty(value="training_file")
        public FineTuningRequestBuilder trainingFile(@NonNull String trainingFile) {
            if (trainingFile == null) {
                throw new NullPointerException("trainingFile is marked non-null but is null");
            }
            this.trainingFile = trainingFile;
            return this;
        }

        @JsonProperty(value="validation_file")
        public FineTuningRequestBuilder validationFile(String validationFile) {
            this.validationFile = validationFile;
            return this;
        }

        @JsonProperty(value="hyperparameters")
        public FineTuningRequestBuilder hyperParameters(HyperParams hyperParameters) {
            this.hyperParameters = hyperParameters;
            return this;
        }

        public FineTuningRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public FineTuningRequest build() {
            return new FineTuningRequest(this.model, this.trainingFile, this.validationFile, this.hyperParameters, this.suffix);
        }

        public String toString() {
            return "FineTuningRequest.FineTuningRequestBuilder(model=" + this.model + ", trainingFile=" + this.trainingFile + ", validationFile=" + this.validationFile + ", hyperParameters=" + this.hyperParameters + ", suffix=" + this.suffix + ")";
        }
    }
}

