/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.AssistantTool;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadCreateAndRunRequest {
    private String assistantId;
    private ThreadMessageList thread;
    private String model;
    private String instructions;
    private List<AssistantTool> tools;
    private Map<String, String> metadata;

    ThreadCreateAndRunRequest(String assistantId, ThreadMessageList thread, String model, String instructions, List<AssistantTool> tools, Map<String, String> metadata) {
        this.assistantId = assistantId;
        this.thread = thread;
        this.model = model;
        this.instructions = instructions;
        this.tools = tools;
        this.metadata = metadata;
    }

    public static ThreadCreateAndRunRequestBuilder builder() {
        return new ThreadCreateAndRunRequestBuilder();
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public ThreadMessageList getThread() {
        return this.thread;
    }

    public String getModel() {
        return this.model;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<AssistantTool> getTools() {
        return this.tools;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class ThreadCreateAndRunRequestBuilder {
        private String assistantId;
        private ThreadMessageList thread;
        private String model;
        private String instructions;
        private ArrayList<AssistantTool> tools;
        private Map<String, String> metadata;

        ThreadCreateAndRunRequestBuilder() {
        }

        public ThreadCreateAndRunRequestBuilder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder thread(ThreadMessageList thread) {
            this.thread = thread;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder tool(AssistantTool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        public ThreadCreateAndRunRequestBuilder tools(Collection<? extends AssistantTool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        public ThreadCreateAndRunRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        public ThreadCreateAndRunRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ThreadCreateAndRunRequest build() {
            List<AssistantTool> tools;
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<AssistantTool>(this.tools));
                }
            }
            return new ThreadCreateAndRunRequest(this.assistantId, this.thread, this.model, this.instructions, tools, this.metadata);
        }

        public String toString() {
            return "ThreadCreateAndRunRequest.ThreadCreateAndRunRequestBuilder(assistantId=" + this.assistantId + ", thread=" + this.thread + ", model=" + this.model + ", instructions=" + this.instructions + ", tools=" + this.tools + ", metadata=" + this.metadata + ")";
        }
    }
}

