/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.github.sashirestela.openai.function.Functional;
import io.github.sashirestela.openai.function.ParametersSerializer;
import lombok.NonNull;

public class ChatFunction {
    @NonNull
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @JsonSerialize(using=ParametersSerializer.class)
    @JsonProperty(value="parameters")
    @NonNull
    private Class<? extends Functional> functionalClass;

    ChatFunction(@NonNull String name, String description, @NonNull Class<? extends Functional> functionalClass) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (functionalClass == null) {
            throw new NullPointerException("functionalClass is marked non-null but is null");
        }
        this.name = name;
        this.description = description;
        this.functionalClass = functionalClass;
    }

    public static ChatFunctionBuilder builder() {
        return new ChatFunctionBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @NonNull
    public Class<? extends Functional> getFunctionalClass() {
        return this.functionalClass;
    }

    public static class ChatFunctionBuilder {
        private String name;
        private String description;
        private Class<? extends Functional> functionalClass;

        ChatFunctionBuilder() {
        }

        public ChatFunctionBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public ChatFunctionBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="parameters")
        public ChatFunctionBuilder functionalClass(@NonNull Class<? extends Functional> functionalClass) {
            if (functionalClass == null) {
                throw new NullPointerException("functionalClass is marked non-null but is null");
            }
            this.functionalClass = functionalClass;
            return this;
        }

        public ChatFunction build() {
            return new ChatFunction(this.name, this.description, this.functionalClass);
        }

        public String toString() {
            return "ChatFunction.ChatFunctionBuilder(name=" + this.name + ", description=" + this.description + ", functionalClass=" + this.functionalClass + ")";
        }
    }
}

