/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.annotation.Body;
import io.github.sashirestela.cleverclient.annotation.BodyPart;
import io.github.sashirestela.cleverclient.annotation.DELETE;
import io.github.sashirestela.cleverclient.annotation.GET;
import io.github.sashirestela.cleverclient.annotation.Multipart;
import io.github.sashirestela.cleverclient.annotation.POST;
import io.github.sashirestela.cleverclient.annotation.Path;
import io.github.sashirestela.cleverclient.annotation.Query;
import io.github.sashirestela.cleverclient.annotation.Resource;
import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.OpenAIDeletedResponse;
import io.github.sashirestela.openai.domain.OpenAIGeneric;
import io.github.sashirestela.openai.domain.audio.AudioRespFmt;
import io.github.sashirestela.openai.domain.audio.AudioResponse;
import io.github.sashirestela.openai.domain.audio.AudioTranscribeRequest;
import io.github.sashirestela.openai.domain.audio.AudioTranslateRequest;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.chat.ChatResponse;
import io.github.sashirestela.openai.domain.completion.CompletionRequest;
import io.github.sashirestela.openai.domain.completion.CompletionResponse;
import io.github.sashirestela.openai.domain.embedding.EmbeddingRequest;
import io.github.sashirestela.openai.domain.embedding.EmbeddingResponse;
import io.github.sashirestela.openai.domain.file.FileRequest;
import io.github.sashirestela.openai.domain.file.FileResponse;
import io.github.sashirestela.openai.domain.finetuning.FineTuningEvent;
import io.github.sashirestela.openai.domain.finetuning.FineTuningRequest;
import io.github.sashirestela.openai.domain.finetuning.FineTuningResponse;
import io.github.sashirestela.openai.domain.image.ImageEditsRequest;
import io.github.sashirestela.openai.domain.image.ImageRequest;
import io.github.sashirestela.openai.domain.image.ImageResponse;
import io.github.sashirestela.openai.domain.image.ImageVariationsRequest;
import io.github.sashirestela.openai.domain.model.ModelResponse;
import io.github.sashirestela.openai.domain.moderation.ModerationRequest;
import io.github.sashirestela.openai.domain.moderation.ModerationResponse;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface OpenAI {

    @Resource(value="/v1/moderations")
    public static interface Moderations {
        @POST
        public CompletableFuture<ModerationResponse> create(@Body ModerationRequest var1);
    }

    @Resource(value="/v1/models")
    public static interface Models {
        default public CompletableFuture<List<ModelResponse>> getList() {
            return this.getListWithOptions(Map.of()).thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<ModelResponse>> getListWithOptions(@BodyPart Map<String, ?> var1);

        @GET(value="/{modelId}")
        public CompletableFuture<ModelResponse> getOne(@Path(value="modelId") String var1);

        @DELETE(value="/{modelId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="modelId") String var1);
    }

    @Resource(value="/v1/images")
    public static interface Images {
        default public CompletableFuture<List<ImageResponse>> create(ImageRequest imageRequest) {
            return this.createWithOptions(imageRequest, Map.of()).thenApply(OpenAIGeneric::getData);
        }

        @POST(value="/generations")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> createWithOptions(@Body ImageRequest var1, @BodyPart Map<String, ?> var2);

        default public CompletableFuture<List<ImageResponse>> createEdits(ImageEditsRequest imageRequest) {
            return this.createEditsWithOptions(imageRequest, Map.of()).thenApply(OpenAIGeneric::getData);
        }

        @Multipart
        @POST(value="/edits")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> createEditsWithOptions(@Body ImageEditsRequest var1, @BodyPart Map<String, ?> var2);

        default public CompletableFuture<List<ImageResponse>> createVariations(ImageVariationsRequest imageRequest) {
            return this.createVariationsWithOptions(imageRequest, Map.of()).thenApply(OpenAIGeneric::getData);
        }

        @Multipart
        @POST(value="/variations")
        public CompletableFuture<OpenAIGeneric<ImageResponse>> createVariationsWithOptions(@Body ImageVariationsRequest var1, @BodyPart Map<String, ?> var2);
    }

    @Resource(value="/v1/fine_tuning/jobs")
    public static interface FineTunings {
        @POST
        public CompletableFuture<FineTuningResponse> create(@Body FineTuningRequest var1);

        default public CompletableFuture<List<FineTuningResponse>> getList(Integer limit, String after) {
            return this.getListWithOptions(limit, after, Map.of()).thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<FineTuningResponse>> getListWithOptions(@Query(value="limit") Integer var1, @Query(value="after") String var2, @BodyPart Map<String, ?> var3);

        @GET(value="/{fineTuningId}")
        public CompletableFuture<FineTuningResponse> getOne(@Path(value="fineTuningId") String var1);

        default public CompletableFuture<List<FineTuningEvent>> getEvents(String fineTuningId, Integer limit, String after) {
            return this.getEventsWithOptions(fineTuningId, limit, after, Map.of()).thenApply(OpenAIGeneric::getData);
        }

        @GET(value="/{fineTuningId}/events")
        public CompletableFuture<OpenAIGeneric<FineTuningEvent>> getEventsWithOptions(@Path(value="fineTuningId") String var1, @Query(value="limit") Integer var2, @Query(value="after") String var3, @BodyPart Map<String, ?> var4);

        @POST(value="/{fineTuningId}/cancel")
        public CompletableFuture<FineTuningResponse> cancel(@Path(value="fineTuningId") String var1);
    }

    @Resource(value="/v1/files")
    public static interface Files {
        @Multipart
        @POST
        public CompletableFuture<FileResponse> create(@Body FileRequest var1);

        default public CompletableFuture<List<FileResponse>> getList() {
            return this.getListWithOptions(Map.of()).thenApply(OpenAIGeneric::getData);
        }

        @GET
        public CompletableFuture<OpenAIGeneric<FileResponse>> getListWithOptions(@BodyPart Map<String, ?> var1);

        @GET(value="/{fileId}")
        public CompletableFuture<FileResponse> getOne(@Path(value="fileId") String var1);

        @GET(value="/{fileId}/content")
        public CompletableFuture<String> getContent(@Path(value="fileId") String var1);

        @DELETE(value="/{fileId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="fileId") String var1);
    }

    @Resource(value="/v1/embeddings")
    public static interface Embeddings {
        @POST
        public CompletableFuture<EmbeddingResponse> create(@Body EmbeddingRequest var1);
    }

    @Resource(value="/v1/completions")
    public static interface Completions {
        default public CompletableFuture<CompletionResponse> create(@Body CompletionRequest completionRequest) {
            return this.createWithOptions(completionRequest, Options.withoutStream());
        }

        @POST
        public CompletableFuture<CompletionResponse> createWithOptions(@Body CompletionRequest var1, @BodyPart Map<String, ?> var2);

        default public CompletableFuture<Stream<CompletionResponse>> createStream(@Body CompletionRequest completionRequest) {
            return this.createStreamWithOptions(completionRequest, Options.withStream());
        }

        @POST
        public CompletableFuture<Stream<CompletionResponse>> createStreamWithOptions(@Body CompletionRequest var1, @BodyPart Map<String, ?> var2);
    }

    @Resource(value="/v1/chat/completions")
    public static interface ChatCompletions {
        default public CompletableFuture<ChatResponse> create(@Body ChatRequest chatRequest) {
            return this.createWithOptions(chatRequest, Options.withoutStream());
        }

        @POST
        public CompletableFuture<ChatResponse> createWithOptions(@Body ChatRequest var1, @BodyPart Map<String, ?> var2);

        default public CompletableFuture<Stream<ChatResponse>> createStream(@Body ChatRequest chatRequest) {
            return this.createStreamWithOptions(chatRequest, Options.withStream());
        }

        @POST
        public CompletableFuture<Stream<ChatResponse>> createStreamWithOptions(@Body ChatRequest var1, @BodyPart Map<String, ?> var2);
    }

    @Resource(value="/v1/audio")
    public static interface Audios {
        default public CompletableFuture<AudioResponse> transcribe(AudioTranscribeRequest audioRequest) {
            return this.transcribeWithOptions(audioRequest, Options.getAudioResponseFormatOrDefault(audioRequest, AudioRespFmt.JSON, "transcribe"));
        }

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<AudioResponse> transcribeWithOptions(@Body AudioTranscribeRequest var1, @BodyPart Map<String, ?> var2);

        default public CompletableFuture<AudioResponse> translate(AudioTranslateRequest audioRequest) {
            return this.translateWithOptions(audioRequest, Options.getAudioResponseFormatOrDefault(audioRequest, AudioRespFmt.JSON, "translate"));
        }

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<AudioResponse> translateWithOptions(@Body AudioTranslateRequest var1, @BodyPart Map<String, ?> var2);

        default public CompletableFuture<String> transcribePlain(AudioTranscribeRequest audioRequest) {
            return this.transcribePlainWithOptions(audioRequest, Options.getAudioResponseFormatOrDefault(audioRequest, AudioRespFmt.TEXT, "transcribePlain"));
        }

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<String> transcribePlainWithOptions(@Body AudioTranscribeRequest var1, @BodyPart Map<String, ?> var2);

        default public CompletableFuture<String> translatePlain(AudioTranslateRequest audioRequest) {
            return this.translatePlainWithOptions(audioRequest, Options.getAudioResponseFormatOrDefault(audioRequest, AudioRespFmt.TEXT, "translatePlain"));
        }

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<String> translatePlainWithOptions(@Body AudioTranslateRequest var1, @BodyPart Map<String, ?> var2);
    }

    public static final class Options {
        private static final Map<String, Object> withStream = Map.of("stream", Boolean.TRUE);
        private static final Map<String, Object> withoutStream = Map.of("stream", Boolean.FALSE);

        public static Map<String, AudioRespFmt> getAudioResponseFormatOrDefault(AudioTranslateRequest audioRequest, AudioRespFmt orDefault, String methodName) {
            EnumSet<AudioRespFmt> jsonEnumSet = EnumSet.of(AudioRespFmt.JSON, AudioRespFmt.VERBOSE_JSON);
            EnumSet<AudioRespFmt> textEnumSet = EnumSet.complementOf(jsonEnumSet);
            boolean isText = textEnumSet.contains((Object)orDefault);
            AudioRespFmt requestedFormat = audioRequest.getResponseFormat();
            if (requestedFormat != null) {
                if (isText != textEnumSet.contains((Object)requestedFormat)) {
                    throw new SimpleUncheckedException("Unexpected responseFormat for the method {0}.", methodName, null);
                }
            } else {
                requestedFormat = orDefault;
            }
            return Map.of("response_format", requestedFormat);
        }

        public static Map<String, Object> withStream() {
            return withStream;
        }

        public static Map<String, Object> withoutStream() {
            return withoutStream;
        }
    }
}

