/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.metadata;

import io.github.sashirestela.openai.http.ReturnType;
import java.util.List;
import java.util.Map;

public class Metadata {
    private String name;
    private Map<String, Method> methods;

    public static MetadataBuilder builder() {
        return new MetadataBuilder();
    }

    public Metadata(String name, Map<String, Method> methods) {
        this.name = name;
        this.methods = methods;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Method> getMethods() {
        return this.methods;
    }

    public static class MetadataBuilder {
        private String name;
        private Map<String, Method> methods;

        MetadataBuilder() {
        }

        public MetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetadataBuilder methods(Map<String, Method> methods) {
            this.methods = methods;
            return this;
        }

        public Metadata build() {
            return new Metadata(this.name, this.methods);
        }

        public String toString() {
            return "Metadata.MetadataBuilder(name=" + this.name + ", methods=" + this.methods + ")";
        }
    }

    public static class Annotation {
        private String name;
        private String value;

        public Annotation(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Parameter {
        private int index;
        private Class<?> type;
        private String annotationValue;

        public static ParameterBuilder builder() {
            return new ParameterBuilder();
        }

        public Parameter(int index, Class<?> type, String annotationValue) {
            this.index = index;
            this.type = type;
            this.annotationValue = annotationValue;
        }

        public int getIndex() {
            return this.index;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getAnnotationValue() {
            return this.annotationValue;
        }

        public static class ParameterBuilder {
            private int index;
            private Class<?> type;
            private String annotationValue;

            ParameterBuilder() {
            }

            public ParameterBuilder index(int index) {
                this.index = index;
                return this;
            }

            public ParameterBuilder type(Class<?> type) {
                this.type = type;
                return this;
            }

            public ParameterBuilder annotationValue(String annotationValue) {
                this.annotationValue = annotationValue;
                return this;
            }

            public Parameter build() {
                return new Parameter(this.index, this.type, this.annotationValue);
            }

            public String toString() {
                return "Metadata.Parameter.ParameterBuilder(index=" + this.index + ", type=" + this.type + ", annotationValue=" + this.annotationValue + ")";
            }
        }
    }

    public static class Method {
        private String name;
        private ReturnType returnType;
        private Annotation httpAnnotation;
        private boolean isMultipart;
        private String url;
        private Map<String, List<Parameter>> parametersByType;

        public static MethodBuilder builder() {
            return new MethodBuilder();
        }

        public Method(String name, ReturnType returnType, Annotation httpAnnotation, boolean isMultipart, String url, Map<String, List<Parameter>> parametersByType) {
            this.name = name;
            this.returnType = returnType;
            this.httpAnnotation = httpAnnotation;
            this.isMultipart = isMultipart;
            this.url = url;
            this.parametersByType = parametersByType;
        }

        public String getName() {
            return this.name;
        }

        public ReturnType getReturnType() {
            return this.returnType;
        }

        public Annotation getHttpAnnotation() {
            return this.httpAnnotation;
        }

        public boolean isMultipart() {
            return this.isMultipart;
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, List<Parameter>> getParametersByType() {
            return this.parametersByType;
        }

        public static class MethodBuilder {
            private String name;
            private ReturnType returnType;
            private Annotation httpAnnotation;
            private boolean isMultipart;
            private String url;
            private Map<String, List<Parameter>> parametersByType;

            MethodBuilder() {
            }

            public MethodBuilder name(String name) {
                this.name = name;
                return this;
            }

            public MethodBuilder returnType(ReturnType returnType) {
                this.returnType = returnType;
                return this;
            }

            public MethodBuilder httpAnnotation(Annotation httpAnnotation) {
                this.httpAnnotation = httpAnnotation;
                return this;
            }

            public MethodBuilder isMultipart(boolean isMultipart) {
                this.isMultipart = isMultipart;
                return this;
            }

            public MethodBuilder url(String url) {
                this.url = url;
                return this;
            }

            public MethodBuilder parametersByType(Map<String, List<Parameter>> parametersByType) {
                this.parametersByType = parametersByType;
                return this;
            }

            public Method build() {
                return new Method(this.name, this.returnType, this.httpAnnotation, this.isMultipart, this.url, this.parametersByType);
            }

            public String toString() {
                return "Metadata.Method.MethodBuilder(name=" + this.name + ", returnType=" + this.returnType + ", httpAnnotation=" + this.httpAnnotation + ", isMultipart=" + this.isMultipart + ", url=" + this.url + ", parametersByType=" + this.parametersByType + ")";
            }
        }
    }
}

