/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.function;

import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.chat.ChatFunction;
import io.github.sashirestela.openai.domain.chat.ChatFunctionCall;
import io.github.sashirestela.openai.function.Functional;
import io.github.sashirestela.openai.support.CommonUtil;
import io.github.sashirestela.openai.support.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FunctionExecutor {
    private Map<String, ChatFunction> mapFunctions = new HashMap<String, ChatFunction>();

    public FunctionExecutor() {
    }

    public FunctionExecutor(List<ChatFunction> functions) {
        this.enrollFunctions(functions);
    }

    public List<ChatFunction> getFunctions() {
        return new ArrayList<ChatFunction>(this.mapFunctions.values());
    }

    public void enrollFunction(ChatFunction function) {
        this.mapFunctions.put(function.getName(), function);
    }

    public void enrollFunctions(List<ChatFunction> functions) {
        if (functions == null) {
            throw new SimpleUncheckedException("No functions were entered.", "", null);
        }
        this.mapFunctions.clear();
        functions.forEach(function -> this.enrollFunction((ChatFunction)function));
    }

    public <T> T execute(ChatFunctionCall functionToCall) {
        if (functionToCall == null || CommonUtil.get().isNullOrEmpty(functionToCall.getName())) {
            throw new SimpleUncheckedException("No function was entered or it does not has a name.", "", null);
        }
        String functionName = functionToCall.getName();
        if (!this.mapFunctions.containsKey(functionName)) {
            throw new SimpleUncheckedException("The function {0} was not enrolled in the executor.", functionName, null);
        }
        try {
            ChatFunction function = this.mapFunctions.get(functionName);
            Functional object = JsonUtil.get().jsonToObject(functionToCall.getArguments(), function.getFunctionalClass());
            Object result = object.execute();
            return (T)result;
        }
        catch (RuntimeException e) {
            throw new SimpleUncheckedException("Cannot execute the function {0}.", functionName, e);
        }
    }
}

