/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.openai.domain.OpenAIDeletedResponse;
import io.github.sashirestela.openai.domain.audio.AudioResponse;
import io.github.sashirestela.openai.domain.audio.AudioTranscribeRequest;
import io.github.sashirestela.openai.domain.audio.AudioTranslateRequest;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.chat.ChatResponse;
import io.github.sashirestela.openai.domain.completion.CompletionRequest;
import io.github.sashirestela.openai.domain.completion.CompletionResponse;
import io.github.sashirestela.openai.domain.embedding.EmbeddingRequest;
import io.github.sashirestela.openai.domain.embedding.EmbeddingResponse;
import io.github.sashirestela.openai.domain.file.FileRequest;
import io.github.sashirestela.openai.domain.file.FileResponse;
import io.github.sashirestela.openai.domain.finetuning.FineTuningEvent;
import io.github.sashirestela.openai.domain.finetuning.FineTuningRequest;
import io.github.sashirestela.openai.domain.finetuning.FineTuningResponse;
import io.github.sashirestela.openai.domain.image.ImageEditsRequest;
import io.github.sashirestela.openai.domain.image.ImageRequest;
import io.github.sashirestela.openai.domain.image.ImageResponse;
import io.github.sashirestela.openai.domain.image.ImageVariationsRequest;
import io.github.sashirestela.openai.domain.model.ModelResponse;
import io.github.sashirestela.openai.domain.moderation.ModerationRequest;
import io.github.sashirestela.openai.domain.moderation.ModerationResponse;
import io.github.sashirestela.openai.http.annotation.Body;
import io.github.sashirestela.openai.http.annotation.DELETE;
import io.github.sashirestela.openai.http.annotation.GET;
import io.github.sashirestela.openai.http.annotation.Multipart;
import io.github.sashirestela.openai.http.annotation.POST;
import io.github.sashirestela.openai.http.annotation.Path;
import io.github.sashirestela.openai.http.annotation.Query;
import io.github.sashirestela.openai.http.annotation.Resource;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

interface OpenAI {

    @Resource(value="/v1/moderations")
    public static interface Moderations {
        @POST
        public CompletableFuture<ModerationResponse> create(@Body ModerationRequest var1);
    }

    @Resource(value="/v1/models")
    public static interface Models {
        @GET
        public CompletableFuture<List<ModelResponse>> getList();

        @GET(value="/{modelId}")
        public CompletableFuture<ModelResponse> getOne(@Path(value="modelId") String var1);

        @DELETE(value="/{modelId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="modelId") String var1);
    }

    @Resource(value="/v1/images")
    public static interface Images {
        @POST(value="/generations")
        public CompletableFuture<List<ImageResponse>> create(@Body ImageRequest var1);

        @Multipart
        @POST(value="/edits")
        public CompletableFuture<List<ImageResponse>> createEdits(@Body ImageEditsRequest var1);

        @Multipart
        @POST(value="/variations")
        public CompletableFuture<List<ImageResponse>> createVariations(@Body ImageVariationsRequest var1);
    }

    @Resource(value="/v1/fine_tuning/jobs")
    public static interface FineTunings {
        @POST
        public CompletableFuture<FineTuningResponse> create(@Body FineTuningRequest var1);

        @GET
        public CompletableFuture<List<FineTuningResponse>> getList(@Query(value="limit") Integer var1, @Query(value="after") String var2);

        @GET(value="/{fineTuningId}")
        public CompletableFuture<FineTuningResponse> getOne(@Path(value="fineTuningId") String var1);

        @GET(value="/{fineTuningId}/events")
        public CompletableFuture<List<FineTuningEvent>> getEvents(@Path(value="fineTuningId") String var1, @Query(value="limit") Integer var2, @Query(value="after") String var3);

        @POST(value="/{fineTuningId}/cancel")
        public CompletableFuture<FineTuningResponse> cancel(@Path(value="fineTuningId") String var1);
    }

    @Resource(value="/v1/files")
    public static interface Files {
        @Multipart
        @POST
        public CompletableFuture<FileResponse> create(@Body FileRequest var1);

        @GET
        public CompletableFuture<List<FileResponse>> getList();

        @GET(value="/{fileId}")
        public CompletableFuture<FileResponse> getOne(@Path(value="fileId") String var1);

        @GET(value="/{fileId}/content")
        public CompletableFuture<String> getContent(@Path(value="fileId") String var1);

        @DELETE(value="/{fileId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="fileId") String var1);
    }

    @Resource(value="/v1/embeddings")
    public static interface Embeddings {
        @POST
        public CompletableFuture<EmbeddingResponse> create(@Body EmbeddingRequest var1);
    }

    @Resource(value="/v1/completions")
    public static interface Completions {
        @POST
        public CompletableFuture<CompletionResponse> create(@Body CompletionRequest var1);

        @POST
        public CompletableFuture<Stream<CompletionResponse>> createStream(@Body CompletionRequest var1);
    }

    @Resource(value="/v1/chat/completions")
    public static interface ChatCompletions {
        @POST
        public CompletableFuture<ChatResponse> create(@Body ChatRequest var1);

        @POST
        public CompletableFuture<Stream<ChatResponse>> createStream(@Body ChatRequest var1);
    }

    @Resource(value="/v1/audio")
    public static interface Audios {
        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<AudioResponse> transcribe(@Body AudioTranscribeRequest var1);

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<AudioResponse> translate(@Body AudioTranslateRequest var1);

        @Multipart
        @POST(value="/transcriptions")
        public CompletableFuture<String> transcribePlain(@Body AudioTranscribeRequest var1);

        @Multipart
        @POST(value="/translations")
        public CompletableFuture<String> translatePlain(@Body AudioTranslateRequest var1);
    }
}

